package com.elitescloud.boot.log.common;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 *
 * @author : chen.niu
 * @description : 业务对象注解 必须应用在
 * @date : 2023-12-11 19:16
 * @deprecated 请使用 {@link com.elitescloud.boot.common.annotation.BusinessObject}
 */

@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Deprecated(since = "3.2.6")
public @interface BusinessObject {
    //是否启用 如果关闭表示这个业务对象不可用
    boolean enabled() default true;
    //业务类型,约定操作类型约定格式： 英文名称:中文名称
    //可创建常量类维护 英文名称不空，中文不空，未来会强校验
    String businessType();
    //业务类型中文
//    String businessName();
    //业务类型描述
    String businessDescription() default "无";

    //业务对象详情
    String businessObjectDetails() default "-";
    //业务对象领域
    String businessObjectDomain() default "-";

    //业务对象do实体类，用于获取实体元数据和数据列权限控制
    Class<?> businessDoClass() default Void.class;
}
