package com.elitescloud.boot.log.common;

import com.elitescloud.cloudt.common.constant.TenantIsolateStrategy;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author : chen.niu
 * @description :  操作范围，定义操作是用于说明范围
 * @date : 2023-11-27 19:54
 * @deprecated 请使用 {@link com.elitescloud.boot.common.annotation.businessobject.OperationStateEnum}
 */
@Deprecated(since = "3.2.6")
public enum OperationStateEnum {
    RELEASED("已发布"),
    TESTING("测试中"),
    DEPRECATED_PLANNED ("计划弃用"),
    DEPRECATED("已弃用"),
    DEVELOPING("开发中"),
    ELSE("其他"),
    ;

    /**
     * 描述
     */
    private final String description;

    OperationStateEnum(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    private static final Map<String, OperationStateEnum> VALUE_MAP = Arrays.stream(OperationStateEnum.values()).collect(Collectors.toMap(OperationStateEnum::name, t -> t, (t1, t2) -> t1));

    public static OperationStateEnum parse(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.get(value);
    }
}
