package com.elitescloud.boot.log.config;

import com.elitescloud.boot.log.common.LogStorageEnum;

import java.util.Set;

/**
 * 日志持久化配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/16
 */
public class LogRepositoryProperties {

    /**
     * 日志存储类型
     */
    private LogStorageEnum storageType = LogStorageEnum.LOG;

    /**
     * 持久化时异常栈的长度，小于0时不限制
     */
    private Integer exceptionStacktraceLength = -1;

    /**
     * 数据库存储配置
     */
    private final Database database = new Database();

    /**
     * elasticsearch存储配置
     */
    private final Elasticsearch elasticsearch = new Elasticsearch();

    public LogStorageEnum getStorageType() {
        return storageType;
    }

    public void setStorageType(LogStorageEnum storageType) {
        this.storageType = storageType;
    }

    public Integer getExceptionStacktraceLength() {
        return exceptionStacktraceLength;
    }

    public void setExceptionStacktraceLength(Integer exceptionStacktraceLength) {
        this.exceptionStacktraceLength = exceptionStacktraceLength;
    }

    public Database getDatabase() {
        return database;
    }

    public Elasticsearch getElasticsearch() {
        return elasticsearch;
    }

    public static class Database {
        /**
         * 驱动名称
         */
        private String driverClassName;

        /**
         * 数据库连接
         */
        private String url;

        /**
         * 数据库用户名
         */
        private String username;

        /**
         * 数据库密码
         */
        private String password;

        public String getDriverClassName() {
            return driverClassName;
        }

        public void setDriverClassName(String driverClassName) {
            this.driverClassName = driverClassName;
        }

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getUsername() {
            return username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    public static class Elasticsearch {
        /**
         * elasticsearch地址
         */
        private Set<String> uris;

        /**
         * 索引不存在时是否自动创建索引
         */
        private Boolean autoCreate = true;

        /**
         * 索引前缀
         */
        private String indexPrefix = "cloudt-log-";

        public Set<String> getUris() {
            return uris;
        }

        public void setUris(Set<String> uris) {
            this.uris = uris;
        }

        public Boolean getAutoCreate() {
            return autoCreate;
        }

        public void setAutoCreate(Boolean autoCreate) {
            this.autoCreate = autoCreate;
        }

        public String getIndexPrefix() {
            return indexPrefix;
        }

        public void setIndexPrefix(String indexPrefix) {
            this.indexPrefix = indexPrefix;
        }
    }
}
