package com.elitescloud.boot.log.interceptor;

import com.elitescloud.cloudt.common.base.ApiResult;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;
import org.springframework.core.MethodParameter;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

/**
 * 返回结果写入链路跟踪ID.
 *
 * @author Kaiser（wang shao）
 * @date 2023/4/27
 */
@ControllerAdvice
@Order(Ordered.LOWEST_PRECEDENCE)
public class TraceIdInterceptor implements ResponseBodyAdvice<ApiResult<?>> {

    @Override
    public boolean supports(@NonNull MethodParameter returnType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        return ApiResult.class.isAssignableFrom(returnType.getParameterType());
    }

    @Override
    public ApiResult<?> beforeBodyWrite(ApiResult<?> body, @NonNull MethodParameter returnType, @NonNull MediaType selectedContentType,
                                        @NonNull Class<? extends HttpMessageConverter<?>> selectedConverterType,
                                        @NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response) {
        if (body != null) {
            body.setTraceId(TraceContext.traceId());
        }
        return body;
    }
}
