package com.elitescloud.boot.log.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.Table;

/**
 * 接口访问日志实体.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/18
 */
//@Entity
@Table(name = "sys_access_log", indexes = {
        @Index(name = "idx_access_log_reqtime", columnList = "requestTime"),
        @Index(name = "idx_access_log_cost", columnList = "cost"),
        @Index(name = "idx_access_log_uri", columnList = "uri"),
        @Index(name = "idx_access_log_userid", columnList = "userId"),
        @Index(name = "idx_access_log_user", columnList = "username"),
        @Index(name = "idx_access_log_platform", columnList = "platformCode"),
        @Index(name = "idx_access_log_app", columnList = "appCode")
})
@Comment("接口访问日志")
@Getter
@Setter
@Accessors(chain = true)
public class AccessLogEntity extends BaseRequestLogEntity {
    private static final long serialVersionUID = -56469281719800877L;

    @Comment("链路跟踪ID")
    @Column
    private String traceId;

    @Comment("线程ID")
    @Column
    private String threadId;

    @Comment("响应体body，JSON格式数据（不是所有接口都记录，需要配置要记录的接口）")
    @Column()
    @Lob
    private String responseBodyTxt;
}
