package com.elitescloud.boot.log.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.Table;

/**
 * 登录日志实体.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/18
 */
//@Entity
@Table(name = "sys_login_log", indexes = {
        @Index(name = "idx_login_log_reqtime", columnList = "requestTime"),
        @Index(name = "idx_login_log_userid", columnList = "userId"),
        @Index(name = "idx_login_log_user", columnList = "username"),
        @Index(name = "idx_login_log_platform", columnList = "platformCode"),
})
@Comment("登录日志")
@Getter
@Setter
@Accessors(chain = true)
public class LoginLogEntity extends BaseRequestLogEntity {
    private static final long serialVersionUID = -5125120081035791711L;

    @Comment("登录方式，（INNER-内部登录、OAUTH2-OAuth2授权登录、SSO-单点登录）")
    @Column
    private String loginMethod;

    @Comment("登录类型，（password-账号密码登录、mobile_pwd-手机号密码登录、mobile_sms-手机号短信登录，wx_minapp-微信小程序登录，account_pwd-通用账号登录）")
    @Column
    private String loginType;

    @Comment("登录终端，（BACKEND-管理端、APP-APP端、APPLET-小程序）")
    @Column
    private String terminal;

    @Comment("用户详细信息，脱敏的相关参数，JSON格式（支持配置是否记录）")
    @Column
    @Lob
    private String userDetail;
}
