package com.elitescloud.boot.log.queue;

import com.elitescloud.boot.log.common.LogStorable;
import com.lmax.disruptor.EventHandler;
import lombok.extern.log4j.Log4j2;

/**
 * 日志事件处理器.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/18
 */
@Log4j2
public class LogEventHandler implements EventHandler<LogEvent> {

    private final LogStorable storable;

    public LogEventHandler(LogStorable storable) {
        this.storable = storable;
    }

    @Override
    public void onEvent(LogEvent event, long sequence, boolean endOfBatch) throws Exception {
        Object logData = event.getLog();
        if (logData == null) {
            return;
        }

        storable.storage(logData);
    }
}
