package com.elitescloud.boot.log.service;

import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.log.model.bo.OperationLogDTO;
import com.elitescloud.cloudt.common.base.ApiResult;

/**
 * @author : chen.niu
 * @description :操作日志发送MQ消息服务接口
 * @date : 2023-11-28 17:41
 */
public interface OperationLogMqMessageService {

    /**
     * 同步发送操作日志方法 会等待日志消息发送成功  使用不期望丢失消息，如果消息失败，业务端做补偿记录。     适合对性能要求高场景，可能会丢失消息。
     *
     * @param operationLogDTO
     * @return 请求对象
     */
    ApiResult<String> sendSyncOperationLogMqMessage(OperationLogDTO operationLogDTO);

    /**
     * 异步发送操作日志方法 不会等待发送成功，接收到后直接返回，单独现场发送。
     *
     * @param operationLogDTO
     * @return 请求对象
     */
    ApiResult<String> sendAsyncOperationLogMqMessage(OperationLogDTO operationLogDTO);

    /**
     * 快速创建一个操作日志对象方法
     * @param businessType         业务类型，用于对业务参数分类。避免不同业务的业务参数重复，可以根据业务定义一个常量
     * @param businessParam        业务参数，用于汇总操作日志查询使用
     * @param operationType        操作类型枚举
     * @param operationDescription 操作描述
     * @return
     */
    OperationLogDTO quickNewOperationLogDTO(
            Enum businessType,
            String businessParam,
            OperationTypeEnum operationType, String operationDescription);
    OperationLogDTO quickNewOperationLogDTO(
            Enum businessType,
            String businessParam,
            com.elitescloud.boot.log.common.OperationTypeEnum operationType, String operationDescription);

    OperationLogDTO quickNewOperationLogDTO(
            String businessType,
            String businessParam,
            OperationTypeEnum operationType, String operationDescription);
    OperationLogDTO quickNewOperationLogDTO(
            String businessType,
            String businessParam,
            com.elitescloud.boot.log.common.OperationTypeEnum operationType, String operationDescription);


}
