package com.elitescloud.cloudt.core.logInfo;


import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

import java.net.InetAddress;
import java.net.UnknownHostException;

/**
 * <p>
 * 配置加载监听器 用于给log4j2加载application中的配置. 这样可以集中多环境配置log
 * 无侵入性,如果没有配置不会造成影响.  但是如果log4j2.xml中配置了引用  log4j2会报错,请观察控制台
 * 在main方法启动工程时设置加入
 * public static void main(String[] args) {
 * ApplicationStartedEventListener asel = new ApplicationStartedEventListener();
 * new SpringApplicationBuilder(YstSystemApplication.class)
 * .initializers(YstSystemApplication::mdcInit)
 * .listeners(asel)
 * .run(args);
 * }
 * <p>
 *
 * @author niuchen
 * @date 2021/3/31
 * @deprecated 使用配置中的环境变量
 */
@Deprecated(forRemoval = true)
@Slf4j
public class ApplicationStartedEventListener implements GenericApplicationListener {

    public static final int DEFAULT_ORDER = Ordered.HIGHEST_PRECEDENCE + 10;

    private static Class<?>[] EVENT_TYPES = {ApplicationStartingEvent.class, ApplicationEnvironmentPreparedEvent.class,
            ApplicationPreparedEvent.class, ContextClosedEvent.class, ApplicationFailedEvent.class};

    private static Class<?>[] SOURCE_TYPES = {SpringApplication.class, ApplicationContext.class};

    public static final String LOG_KAFKAURI = "kafkaUri";
    public static final String LOG_APPNAME = "appName";
    public static final String LOG_PORT = "port";
    public static final String LOG_GROUPNAME = "groupName";

    public static final String APP_KAFKAURI = "log4j2.kafka.uri";
    public static final String APP_APPNAME = "spring.application.name";
    public static final String APP_PORT = "server.port";
    public static final String APP_GROUPNAME = "log4j2.logext.groupName";

    public static final String APP_D_KAFKAURI = "LOG4J2_KAFKA_URI";
    public static final String APP_D_APPNAME = "SPRING_APPLICATION_NAME";
    public static final String APP_D_PORT = "SERVER_PORT";
    public static final String APP_D_GROUPNAME = "LOG4J2_LOGEXT_GROUPNAME";

//    /***提供给main方法使用 .  初始化完成后 可以读取上下文 废弃因为log42优先级这个方法。 无法生效。
//     * new SpringApplicationBuilder(YstSystemApplication.class)
//     .initializers(ApplicationStartedEventListener::mdcInit)
//     .run(args);***/
//    public static void mdcInit(ConfigurableApplicationContext context) {
//        // 获取配置文件中的拓展配置
////        String project = context.getEnvironment().getProperty("log4j2.log-ext.project");
//        String group = context.getEnvironment().getProperty("log4j2.logext.groupName");
//        String kafkaUri = context.getEnvironment().getProperty("log4j2.kafka.uri");
//        String appName = context.getEnvironment().getProperty("spring.application.name");
//        String port = context.getEnvironment().getProperty("server.port");
//        String ip = getIp();
//
//        System.setProperty("log-appName", null == appName ? "default" : appName);
//        System.setProperty("log-kafkaUri", null == appName ? "default" : kafkaUri);
//        System.setProperty("log-groupName", null == appName ? "default" : group);
//        System.setProperty("log-port", null == appName ? "default" : port);
//        System.setProperty("log-ip", null == ip ? "default" : ip);
////        // 将配置写入log4j2上下文
////        MDC.put("appName", null == appName ? "default" :appName);
////        MDC.put("port", null == port ? "default" :port);
////        MDC.put("kafkaUri", null == kafkaUri ? "default" :kafkaUri);
////        MDC.put("app_group", null == group ? "default" : group);
////        MDC.put("env", null == project ? "default" : env);
//    }


    /*****版本兼容性差.有的版本不是ApplicationEnvironmentPreparedEvent类型 所以无法进入****/
    @Override
    public void onApplicationEvent(ApplicationEvent event) {
        log.info("----------------------log4j上下文环境变量加载----------------------------");
        if (event instanceof ApplicationEnvironmentPreparedEvent) {

            ConfigurableEnvironment envi = ((ApplicationEnvironmentPreparedEvent) event).getEnvironment();
            MutablePropertySources mps = envi.getPropertySources();

//            PropertySource<?> ps = mps.get("applicationConfigurationProperties");

            for (PropertySource<?> propertySource : mps) {
                if (propertySource.getName().contains("applicationConfig: [classpath:/config/application.yml]")) {
                    log.info("---------------------- 变量读取 application.yml----------------------------"+propertySource.getProperty(APP_APPNAME));
                    if (propertySource.containsProperty(APP_APPNAME)) {
                        String appName = propertySource.getProperty(APP_APPNAME).toString();
                        if (appName != null) {
                            MDC.put(LOG_APPNAME, appName);
                        }
                    }
                    log.info("---------------------- 变量读取 application.yml----------------------------"+propertySource.getProperty(APP_PORT));
                    if (propertySource.containsProperty(APP_PORT)) {
                        Object port = propertySource.getProperty(APP_PORT);
                        if (port != null) {
                            MDC.put(LOG_PORT, port.toString());
                        }
                    }
                    log.info("---------------------- 变量读取 application.yml----------------------------"+propertySource.getProperty(APP_KAFKAURI));
                    if (propertySource.containsProperty(APP_KAFKAURI)) {
                        MDC.put(LOG_KAFKAURI, (String) propertySource.getProperty(APP_KAFKAURI));
                    }
                    log.info("---------------------- 变量读取 application.yml----------------------------"+propertySource.getProperty(APP_GROUPNAME));
                     if (propertySource.containsProperty(APP_GROUPNAME)) {
                        MDC.put(LOG_GROUPNAME, (String) propertySource.getProperty(APP_GROUPNAME));
                    }
                } else if (propertySource.getName().contains("applicationConfig:")) {
                    log.info("---------------------- 变量读取 applicationConfig：----------------------------"+propertySource.getProperty(APP_KAFKAURI));
                     if (propertySource.containsProperty(APP_KAFKAURI)) {
                        MDC.put(LOG_KAFKAURI, (String) propertySource.getProperty(APP_KAFKAURI));
                    }
                }
            }

            String ip = getIp();
            if (StringUtils.isNotBlank(ip)) {
                MDC.put("ip", ip);
            }
        }

        setServiceSystemEnv();
        log.info("----------------------log4j上下文环境变量加载end----------------------------");
    }

    /**
     * 读取运行环境参数。 运行环境参数优先级最高，
     ***/
    private void setServiceSystemEnv() {
        String kafkaUriEnv = System.getenv().get(APP_KAFKAURI);
        String groupNameEnv = System.getenv().get(APP_GROUPNAME);
        String appNameEnv = System.getenv().get(APP_APPNAME);
        String appPort = System.getenv().get(APP_PORT);
        log.info("---------------------- system系统环境变量读取 kafkaUriEnv ----------------------------"+kafkaUriEnv);
        log.info("---------------------- system系统环境变量读取 kafkaUriEnv ----------------------------"+groupNameEnv);
        log.info("---------------------- system系统环境变量读取 appNameEnv ----------------------------"+appNameEnv);
        log.info("---------------------- system系统环境变量读取 appPort ----------------------------"+appPort);

        if (kafkaUriEnv != null && kafkaUriEnv.length() > 0) {
            MDC.put(LOG_KAFKAURI, kafkaUriEnv);
        } else {
            kafkaUriEnv = System.getenv().get(APP_D_KAFKAURI);
            if (kafkaUriEnv != null && kafkaUriEnv.length() > 0) {
                MDC.put(LOG_KAFKAURI, kafkaUriEnv);
            }
        }

        if (groupNameEnv != null && groupNameEnv.length() > 0) {
            MDC.put(LOG_GROUPNAME, groupNameEnv);
        } else {
            groupNameEnv = System.getenv().get(APP_D_GROUPNAME);
            if (groupNameEnv != null && groupNameEnv.length() > 0) {
                MDC.put(LOG_GROUPNAME, groupNameEnv);
            }
        }

        if (appNameEnv != null && appNameEnv.length() > 0) {
            MDC.put(LOG_APPNAME, appNameEnv);
        } else {
            appNameEnv = System.getenv().get(APP_D_APPNAME);
            if (appNameEnv != null && appNameEnv.length() > 0) {
                MDC.put(LOG_APPNAME, appNameEnv);
            }
        }

        if (appPort != null && appPort.length() > 0) {
            MDC.put(LOG_PORT, appPort);
        } else {
            appPort = System.getenv().get(APP_D_PORT);
            if (appPort != null && appPort.length() > 0) {
                MDC.put(LOG_PORT, appPort);
            }
        }
    }

    @Override
    public int getOrder() {
        return DEFAULT_ORDER;
    }

    @Override
    public boolean supportsEventType(ResolvableType resolvableType) {
        return isAssignableFrom(resolvableType.getRawClass(), EVENT_TYPES);
    }

    @Override
    public boolean supportsSourceType(Class<?> sourceType) {
        return isAssignableFrom(sourceType, SOURCE_TYPES);
    }

    private boolean isAssignableFrom(Class<?> type, Class<?>... supportedTypes) {
        if (type != null) {
            for (Class<?> supportedType : supportedTypes) {
                if (supportedType.isAssignableFrom(type)) {
                    return true;
                }
            }
        }
        return false;
    }


    private static String getIp() {
        InetAddress ip;
        try {
            ip = InetAddress.getLocalHost();
        } catch (UnknownHostException e) {
            e.printStackTrace();
            return "";
        }

        return ip.getHostAddress();
    }


}
