package com.elitescloud.cloudt.core.logInfo.tracking;

/**
 * <p>
 * 功能说明
 * </p >
 *
 * @author niu.chen
 * @date 2021-06-12
 */
public enum EventTrackingLogLevelEnum {


    /**
     * No events will be logged.
     */
    OFF(0),

    /**
     * A severe error that will prevent the application from continuing.
     */
    FATAL(100),

    /**
     * An error in the application, possibly recoverable.
     */
    ERROR(200),

    /**
     * An event that might possible lead to an error.
     */
    WARN(300),

    /**
     * An event for informational purposes.
     */
    INFO(400),

    /**
     * A general debugging event.
     */
    DEBUG(500),

    /**
     * A fine-grained debug message, typically capturing the flow through the application.
     */
    TRACE(600),

    /**
     * All events should be logged.
     */
    ALL(Integer.MAX_VALUE);


//    , INC_QTY_REPLACE("INC_QTY_REPLACE")
//    , INC_QTY_LOGICAL_DELETE("INC_QTY_LOGICAL_DELETE")
    ;

//    private String level;

    private final int intLevel;

    EventTrackingLogLevelEnum(final int val) {
        intLevel = val;
    }

    /**
     * Returns the integer value of the Level.
     *
     * @return the integer value of the Level.
     */
    public int intLevel() {
        return intLevel;
    }




}
