/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.log;

import com.elitescloud.boot.log.interceptor.BusinessOperationLogAspect;
import com.elitescloud.boot.log.service.DynamicMessageService;
import com.elitescloud.boot.log.service.OperationLogMqMessageDefaultServiceImpl;
import com.elitescloud.boot.log.service.OperationLogMqMessageService;
import com.elitescloud.boot.log.service.OperationLogMqMessageServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.core.task.TaskExecutor;

@ConditionalOnClass(value={StreamBridge.class})
public class CloudOperationLogAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CloudOperationLogAutoConfiguration.class);

    public CloudOperationLogAutoConfiguration() {
        log.info("\u542f\u7528\u64cd\u4f5c\u65e5\u5fd7");
    }

    @Bean
    public DynamicMessageService dynamicMessageService(StreamBridge streamBridge) {
        return new DynamicMessageService(streamBridge);
    }

    @Bean
    @ConditionalOnMissingBean
    public OperationLogMqMessageService operationLogMqMessageService(Environment environment) {
        return new OperationLogMqMessageDefaultServiceImpl(environment);
    }

    @Bean
    @ConditionalOnProperty(prefix="elitesland.log.operation-log", name={"enabled"}, havingValue="true")
    public OperationLogMqMessageService operationLogMqMessageService(Environment environment, DynamicMessageService dynamicMessageService, TaskExecutor taskExecutor) {
        return new OperationLogMqMessageServiceImpl(dynamicMessageService, environment, taskExecutor);
    }

    @ConditionalOnProperty(prefix="elitesland.log.operation-log-aspect", name={"enabled"}, havingValue="true")
    @Bean
    BusinessOperationLogAspect businessOperationLogAspect(OperationLogMqMessageService operationLogService) {
        return new BusinessOperationLogAspect(operationLogService);
    }
}

