/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.log;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.log.interceptor.TraceIdInterceptor;
import com.elitescloud.boot.log.provider.trace.EventTrackingLog4j2Impl;
import com.elitescloud.boot.threadpool.common.ContextTransfer;
import com.elitescloud.cloudt.core.logInfo.tracking.EventTrackingInterface;
import java.util.Map;
import org.slf4j.MDC;
import org.springframework.context.annotation.Bean;

class CloudtTraceAutoConfiguration {
    CloudtTraceAutoConfiguration() {
    }

    @Bean
    public EventTrackingInterface eventTrackingLog4j2() {
        return new EventTrackingLog4j2Impl();
    }

    @Bean
    public TraceIdInterceptor traceIdInterceptor() {
        return new TraceIdInterceptor();
    }

    @Bean
    public ContextTransfer<Map<String, String>> mdcContextTransfer() {
        return new ContextTransfer<Map<String, String>>(){

            public Map<String, String> getContext() {
                return MDC.getCopyOfContextMap();
            }

            public void setContext(Map<String, String> context) {
                if (CollUtil.isEmpty(context)) {
                    return;
                }
                MDC.setContextMap(context);
            }

            public void clearContext() {
                MDC.clear();
            }
        };
    }
}

