/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.log.provider.storage;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.http.useragent.UserAgent;
import cn.hutool.http.useragent.UserAgentUtil;
import com.elitescloud.boot.log.LogProperties;
import com.elitescloud.boot.log.common.LogStorable;
import com.elitescloud.boot.log.convert.LogConvert;
import com.elitescloud.boot.log.model.bo.AccessLogBO;
import com.elitescloud.boot.log.model.bo.BaseRequestLogBO;
import com.elitescloud.boot.log.model.bo.LoginLogBO;
import com.elitescloud.boot.log.model.entity.AccessLogEntity;
import com.elitescloud.boot.log.model.entity.BaseRequestLogEntity;
import com.elitescloud.boot.log.model.entity.LoginLogEntity;
import com.elitescloud.boot.provider.IdFactory;
import com.elitescloud.boot.support.app.CloudtAppHolder;
import com.elitescloud.boot.util.JwtUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractLogStorage
implements LogStorable {
    private static final Logger log = LogManager.getLogger(AbstractLogStorage.class);
    protected final ObjectMapper objectMapper;
    protected static final LogConvert CONVERT = LogConvert.INSTANCE;
    protected final LogProperties logProperties;

    protected AbstractLogStorage(LogProperties logProperties) {
        this.logProperties = logProperties;
        this.objectMapper = this.buildObjectMapper();
    }

    public abstract void saveAccessLog(AccessLogEntity var1);

    public abstract void saveLoginLog(LoginLogEntity var1);

    public abstract void removeExpiredAccessLog(LocalDateTime var1);

    public abstract void removeExpiredLoginLog(LocalDateTime var1);

    @Override
    public void storage(Object log) {
        if (log == null) {
            return;
        }
        if (log instanceof AccessLogBO) {
            AccessLogEntity entity = this.toEntity((AccessLogBO)log);
            this.saveAccessLog(entity);
        } else if (log instanceof LoginLogBO) {
            LoginLogEntity entity = this.toEntity((LoginLogBO)log);
            this.saveLoginLog(entity);
        }
    }

    @Override
    public void clearExpired(Class<?> logType, LocalDateTime expiredTime) {
        Assert.notNull((Object)expiredTime, (String)"\u8fc7\u671f\u65f6\u95f4\u4e3a\u7a7a");
        if (logType == AccessLogBO.class) {
            this.removeExpiredAccessLog(expiredTime);
        } else if (logType == LoginLogBO.class) {
            this.removeExpiredLoginLog(expiredTime);
        }
    }

    protected Long generateId() {
        return IdFactory.generateLong();
    }

    protected String obj2Json(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj.getClass().isPrimitive()) {
            return obj.toString();
        }
        try {
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            log.error("\u8f6c\u6362JSON\u5b57\u7b26\u4e32\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }

    private AccessLogEntity toEntity(AccessLogBO logBO) {
        AccessLogEntity entity = CONVERT.toEntity(logBO);
        this.fillBaseEntity(entity, logBO);
        entity.setResponseBodyTxt(this.obj2Json(logBO.getResult()));
        return entity;
    }

    private LoginLogEntity toEntity(LoginLogBO logBO) {
        LoginLogEntity entity = CONVERT.toEntity(logBO);
        this.fillBaseEntity(entity, logBO);
        entity.setUserDetail(this.obj2Json(logBO.getUserDetailObj()));
        return entity;
    }

    private <T extends BaseRequestLogEntity, S extends BaseRequestLogBO> void fillBaseEntity(T entity, S bo) {
        List<Object> requestBodies;
        UserAgent userAgent;
        entity.setId(this.generateId());
        entity.setCost(Duration.between(entity.getRequestTime(), entity.getResponseTime()).toMillis());
        Map<String, Object> claims = this.decodeToken(bo.getToken());
        if (!claims.isEmpty()) {
            entity.setPlatformCode((String)claims.get("yst_ptc"));
            entity.setClientId((String)claims.get("yst_cli"));
            if (claims.containsKey("yst_ui")) {
                entity.setUserId(Long.parseLong(claims.get("yst_ui").toString()));
            }
            entity.setUsername((String)claims.get("yst_un"));
        }
        if ((userAgent = UserAgentUtil.parse((String)entity.getUserAgent())) != null) {
            entity.setBrowser(userAgent.getBrowser().getName());
        }
        if (!CollectionUtils.isEmpty(requestBodies = bo.getRequestBody())) {
            entity.setRequestBodyTxt(requestBodies.size() == 1 ? this.obj2Json(requestBodies.get(0)) : this.obj2Json(requestBodies));
        }
        entity.setServerInstance(CloudtAppHolder.getServerInstance());
        entity.setServerInstanceIp(CloudtAppHolder.getServerIp());
        entity.setAppCode(CloudtAppHolder.getAppCode());
        Integer resultCode = entity.getResultCode();
        entity.setSuccess(resultCode != null && resultCode >= 200 && resultCode < 300);
        if (bo.getThrowable() != null) {
            Integer limit = this.logProperties.getRepository().getExceptionStacktraceLength();
            entity.setException(ExceptionUtil.stacktraceToString((Throwable)bo.getThrowable(), (int)limit));
        }
    }

    private Map<String, Object> decodeToken(String token) {
        if (!StringUtils.hasText((String)token)) {
            return Collections.emptyMap();
        }
        try {
            return JwtUtil.decode((String)token);
        }
        catch (Exception e) {
            log.warn("\u89e3\u5bc6token\u5931\u8d25\uff1a", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private ObjectMapper buildObjectMapper() {
        return new Jackson2ObjectMapperBuilder().simpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").serializerByType(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"))).serializerByType(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd"))).build();
    }
}

