/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.log.service;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.context.ExecutorContextHolder;
import com.elitescloud.boot.log.common.OperationTypeEnum;
import com.elitescloud.boot.log.model.bo.OperationLogDTO;
import com.elitescloud.boot.log.service.OperationLogMqMessageService;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.core.env.Environment;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class OperationLogMqMessageDefaultServiceImpl
implements OperationLogMqMessageService {
    private static final Logger log = LoggerFactory.getLogger(OperationLogMqMessageDefaultServiceImpl.class);
    private final Environment environment;

    public OperationLogMqMessageDefaultServiceImpl(Environment environment) {
        this.environment = environment;
    }

    @Override
    public ApiResult<String> sendSyncOperationLogMqMessage(OperationLogDTO operationLogDTO) {
        log.info("\u64cd\u4f5c\u65e5\u5fd7\u914d\u7f6e\u5173\u95ed\uff0c\u4e0d\u53d1\u9001\u65e5\u5fd7: {}", (Object)operationLogDTO);
        return ApiResult.ok((Object)"\u64cd\u4f5c\u65e5\u5fd7\u914d\u7f6e\u5173\u95ed\uff0c\u4e0d\u53d1\u9001\u65e5\u5fd7");
    }

    @Override
    public ApiResult<String> sendAsyncOperationLogMqMessage(OperationLogDTO operationLogDTO) {
        log.info("\u64cd\u4f5c\u65e5\u5fd7\u914d\u7f6e\u5173\u95ed\uff0c\u4e0d\u53d1\u9001\u65e5\u5fd7: {}", (Object)operationLogDTO);
        return ApiResult.ok((Object)"\u64cd\u4f5c\u65e5\u5fd7\u914d\u7f6e\u5173\u95ed\uff0c\u4e0d\u53d1\u9001\u65e5\u5fd7");
    }

    @Override
    public OperationLogDTO quickNewOperationLogDTO(Enum businessType, String businessParam, com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum operationType, String operationDescription) {
        return OperationLogMqMessageDefaultServiceImpl.getOperationLogDTO(businessType.name(), businessParam, operationType, operationDescription, this.environment);
    }

    @Override
    public OperationLogDTO quickNewOperationLogDTO(Enum businessType, String businessParam, OperationTypeEnum operationType, String operationDescription) {
        return OperationLogMqMessageDefaultServiceImpl.getOperationLogDTO(businessType.name(), businessParam, operationType, operationDescription, this.environment);
    }

    @Override
    public OperationLogDTO quickNewOperationLogDTO(String businessType, String businessParam, com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum operationType, String operationDescription) {
        return OperationLogMqMessageDefaultServiceImpl.getOperationLogDTO(businessType, businessParam, operationType, operationDescription, this.environment);
    }

    @Override
    public OperationLogDTO quickNewOperationLogDTO(String businessType, String businessParam, OperationTypeEnum operationType, String operationDescription) {
        return OperationLogMqMessageDefaultServiceImpl.getOperationLogDTO(businessType, businessParam, operationType, operationDescription, this.environment);
    }

    public static OperationLogDTO getOperationLogDTO(String businessType, String businessParam, com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum operationType, String operationDescription, Environment environment) {
        OperationLogDTO operationLogDTO = OperationLogDTO.builder().build();
        operationLogDTO.setSource("artificial");
        operationLogDTO.setBusinessParam(businessParam);
        operationLogDTO.setBusinessType(businessType);
        operationLogDTO.setSuccess(true);
        operationLogDTO.setOperationType(operationType.name());
        operationLogDTO.setOperationTypeName(operationType.getDescription());
        operationLogDTO.setOperationDescription(operationDescription);
        operationLogDTO.setAppName(environment.getProperty("spring.application.name"));
        HttpServletRequest request = HttpServletUtil.currentRequest();
        if (HttpServletUtil.currentRequest() != null) {
            operationLogDTO.setMenuCode(request.getHeader("menuCode"));
            operationLogDTO.setRequestUrl(request.getRequestURI());
            operationLogDTO.setRequestMethod(request.getMethod());
            operationLogDTO.setOperationIp(HttpServletUtil.currentClientIp());
        } else {
            operationLogDTO.setMenuCode("\u65e0\u83dc\u5355");
            operationLogDTO.setRequestUrl("\u975eHTTP\u8bf7\u6c42");
            operationLogDTO.setRequestMethod("\u975eHTTP\u8bf7\u6c42");
            log.info("HttpServletRequest Null");
        }
        operationLogDTO.setToken(SecurityContextUtil.currentToken());
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user != null) {
            operationLogDTO.setOperationUserName(user.getUsername());
            operationLogDTO.setOperationUserId(user.getUserId());
            operationLogDTO.setTenantId(user.getTenantId() == null ? -1L : user.getTenantId());
            operationLogDTO.setOperationName(user.getUser().getLastName());
        } else {
            operationLogDTO.setOperationUserName("-");
            operationLogDTO.setOperationUserId(0L);
            operationLogDTO.setTenantId(-1L);
            operationLogDTO.setOperationName("-");
            log.info("SecurityContextUtil.currentUser Null {}", (Object)operationLogDTO);
        }
        DateTime now = DateUtil.date();
        String formattedNow = DateUtil.format((Date)now, (String)"yyyy-MM-dd HH:mm:ss.SSS");
        operationLogDTO.setOperationTime(formattedNow);
        operationLogDTO.setTraceIdSys(MDC.get((String)"cloudt_traceId"));
        operationLogDTO.setTraceIdExt(TraceContext.traceId());
        return operationLogDTO;
    }

    public static OperationLogDTO getOperationLogDTO(String businessType, String businessParam, OperationTypeEnum operationType, String operationDescription, Environment environment) {
        OperationLogDTO operationLogDTO = OperationLogDTO.builder().build();
        operationLogDTO.setSource("artificial");
        operationLogDTO.setBusinessParam(businessParam);
        operationLogDTO.setBusinessType(businessType);
        operationLogDTO.setSuccess(true);
        operationLogDTO.setOperationType(operationType.name());
        operationLogDTO.setOperationTypeName(operationType.getDescription());
        operationLogDTO.setOperationDescription(operationDescription);
        operationLogDTO.setAppName(environment.getProperty("spring.application.name"));
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        if (request != null) {
            operationLogDTO.setMenuCode(request.getHeader("menuCode"));
            operationLogDTO.setRequestUrl(request.getRequestURI());
            operationLogDTO.setRequestMethod(request.getMethod());
            operationLogDTO.setOperationIp(HttpServletUtil.currentClientIp());
        } else {
            operationLogDTO.setMenuCode("\u65e0\u83dc\u5355");
            operationLogDTO.setRequestUrl("\u975eHTTP\u8bf7\u6c42");
            operationLogDTO.setRequestMethod("\u975eHTTP\u8bf7\u6c42");
            log.info("HttpServletRequest Null");
        }
        operationLogDTO.setToken(SecurityContextUtil.currentToken());
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user != null) {
            operationLogDTO.setOperationUserName(user.getUsername());
            operationLogDTO.setOperationUserId(user.getUserId());
            operationLogDTO.setTenantId(user.getTenantId() == null ? -1L : user.getTenantId());
            operationLogDTO.setOperationName(user.getUser().getLastName());
        } else {
            operationLogDTO.setOperationUserName("-");
            operationLogDTO.setOperationUserId(0L);
            operationLogDTO.setTenantId(-1L);
            operationLogDTO.setOperationName("-");
            log.info("SecurityContextUtil.currentUser Null");
        }
        DateTime now = DateUtil.date();
        String formattedNow = DateUtil.format((Date)now, (String)"yyyy-MM-dd HH:mm:ss.SSS");
        operationLogDTO.setOperationTime(formattedNow);
        operationLogDTO.setTraceIdSys(MDC.get((String)"cloudt_traceId"));
        operationLogDTO.setTraceIdExt(TraceContext.traceId());
        ExecutorContextHolder.ExecutorContext executor = ExecutorContextHolder.get();
        if (executor != null) {
            operationLogDTO.setExecutorSource(executor.getSource().name());
        }
        return operationLogDTO;
    }
}

