/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.log;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.log.LogProperties;
import com.elitescloud.boot.log.common.LogStorable;
import com.elitescloud.boot.log.common.filter.LoggerNameFilter;
import com.elitescloud.boot.log.config.AccessLogConfig;
import com.elitescloud.boot.log.config.LogStorageConfig;
import com.elitescloud.boot.log.config.LoginLogConfig;
import com.elitescloud.boot.log.queue.LogEvent;
import com.elitescloud.boot.log.queue.LogEventFactory;
import com.elitescloud.boot.log.queue.LogEventHandler;
import com.elitescloud.boot.util.ClassUtil;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TimeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.filter.CompositeFilter;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.slf4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.concurrent.ThreadPoolExecutorFactoryBean;

@ConditionalOnProperty(prefix="elitesland.log", name={"enabled"}, havingValue="true", matchIfMissing=true)
@Import(value={Log4j2Config.class, LogStorageConfig.class, LoginLogConfig.class, AccessLogConfig.class})
class CloudtLogAutoConfiguration {
    private static final Logger logger = CloudtBootLoggerFactory.LOG.getLogger(CloudtLogAutoConfiguration.class);
    private final LogProperties logProperties;

    public CloudtLogAutoConfiguration(LogProperties logProperties) {
        this.logProperties = logProperties;
    }

    @Bean(value={"logEventRingBuffer"})
    public RingBuffer<LogEvent> logEventRingBuffer(LogStorable storable) {
        int bufferSize = 262144;
        ThreadPoolExecutorFactoryBean executorFactoryBean = new ThreadPoolExecutorFactoryBean();
        LogProperties.ThreadPool threadPool = this.logProperties.getThreadPool();
        executorFactoryBean.setThreadNamePrefix(threadPool.getThreadNamePrefix());
        executorFactoryBean.setCorePoolSize(threadPool.getCoreSize().intValue());
        executorFactoryBean.setMaxPoolSize(threadPool.getMaxSize().intValue());
        Disruptor disruptor = new Disruptor((EventFactory)new LogEventFactory(), bufferSize, (ThreadFactory)executorFactoryBean, ProducerType.SINGLE, (WaitStrategy)new BlockingWaitStrategy());
        disruptor.handleEventsWith(new EventHandler[]{new LogEventHandler(storable)});
        disruptor.setDefaultExceptionHandler((ExceptionHandler)new ExceptionHandler<LogEvent>(){

            public void handleEventException(Throwable ex, long sequence, LogEvent event) {
                logger.error("\u65e5\u5fd7\u5904\u7406\u5f02\u5e38\uff1a", ex);
            }

            public void handleOnStartException(Throwable ex) {
                logger.error("\u65e5\u5fd7\u542f\u52a8\u5904\u7406\u5f02\u5e38\uff1a", ex);
            }

            public void handleOnShutdownException(Throwable ex) {
                logger.error("\u65e5\u5fd7\u7ed3\u675f\u5904\u7406\u5f02\u5e38\uff1a", ex);
            }
        });
        disruptor.start();
        return disruptor.getRingBuffer();
    }

    static class Log4j2Config
    implements InitializingBean {
        private final LogProperties logProperties;

        public Log4j2Config(LogProperties logProperties) {
            this.logProperties = logProperties;
        }

        public void afterPropertiesSet() throws Exception {
            this.addCloudtLogAppender();
        }

        private void addCloudtLogAppender() {
            if (CollUtil.isEmpty(this.logProperties.getCloudtAppenders())) {
                return;
            }
            org.apache.logging.log4j.spi.LoggerContext ctx = LogManager.getContext((boolean)false);
            if (!(ctx instanceof LoggerContext)) {
                logger.error("\u6682\u4e0d\u652f\u6301\u7684\u65e5\u5fd7\u7c7b\u578b\uff1a{}\uff0c\u65e0\u6cd5\u521b\u5efaCloudtLogAppender", (Object)ClassUtil.getTargetClass((Object)ctx).getName());
                return;
            }
            LoggerContext context = (LoggerContext)ctx;
            Configuration config = context.getConfiguration();
            boolean updated = false;
            for (Map.Entry<String, LogProperties.LogAppender> entry : this.logProperties.getCloudtAppenders().entrySet()) {
                if (config.getAppenders().containsKey(entry.getKey())) {
                    logger.info("{} has exists", (Object)entry.getKey());
                    return;
                }
                logger.info("add LogAppender\uff1a{} - {}", (Object)entry.getKey(), (Object)String.join((CharSequence)",", entry.getValue().getFilterLogNames()));
                PatternLayout layout = PatternLayout.newBuilder().withPattern(entry.getValue().getLayoutPattern()).build();
                CompositeFilter filters = CompositeFilter.createFilters(null);
                for (String filterLevel : entry.getValue().getFilterLevels()) {
                    filters = filters.addFilter((Filter)ThresholdFilter.createFilter((Level)Level.toLevel((String)filterLevel), (Filter.Result)Filter.Result.NEUTRAL, (Filter.Result)Filter.Result.DENY));
                }
                if (CollUtil.isNotEmpty(entry.getValue().getFilterLogNames())) {
                    filters = filters.addFilter((Filter)new LoggerNameFilter(Filter.Result.ACCEPT, Filter.Result.DENY, entry.getValue().getFilterLogNames(), true));
                }
                RollingFileAppender appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().setConfiguration(config)).setName(entry.getKey())).setLayout((Layout)layout)).withFilePattern(entry.getValue().getFilePattern()).withFileName(entry.getValue().getFileName()).withPolicy((TriggeringPolicy)TimeBasedTriggeringPolicy.newBuilder().withInterval(entry.getValue().getTimeBasedTriggerPolicyInterval()).withModulate(entry.getValue().isTimeBasedTriggerPolicyModulate()).build()).withPolicy((TriggeringPolicy)SizeBasedTriggeringPolicy.createPolicy((String)entry.getValue().getSizedBasedTriggerPolicySize())).withStrategy((RolloverStrategy)DefaultRolloverStrategy.newBuilder().withMax(entry.getValue().getRolloverStrategyMax()).build()).setFilter((Filter)filters)).build();
                appender.start();
                config.getRootLogger().addAppender((Appender)appender, Level.INFO, null);
                config.addAppender((Appender)appender);
                updated = true;
            }
            if (updated) {
                context.updateLoggers();
            }
        }
    }
}

