/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.log.provider.storage;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch.core.DeleteByQueryRequest;
import co.elastic.clients.elasticsearch.indices.CreateIndexResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.util.ObjectBuilder;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.log.LogProperties;
import com.elitescloud.boot.log.config.LogRepositoryProperties;
import com.elitescloud.boot.log.model.entity.AccessLogEntity;
import com.elitescloud.boot.log.model.entity.LoginLogEntity;
import com.elitescloud.boot.log.provider.storage.AbstractLogStorage;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;

public class ElasticsearchStorage
extends AbstractLogStorage {
    private static final Logger logger = CloudtBootLoggerFactory.LOG.getLogger(ElasticsearchStorage.class);
    private final ElasticsearchClient elasticsearchClient;
    private final LogRepositoryProperties.Elasticsearch config;

    public ElasticsearchStorage(LogProperties logProperties, ElasticsearchClient elasticsearchClient) {
        super(logProperties);
        this.elasticsearchClient = elasticsearchClient;
        this.config = logProperties.getRepository().getElasticsearch();
        CompletableFuture.runAsync(this::checkIndexExists).whenComplete((res, e) -> {
            if (e == null) {
                logger.info("\u65e5\u5fd7\u6301\u4e45\u5316\u65b9\u5f0fElasticsearch\u521d\u59cb\u5316\u6210\u529f\uff01");
                return;
            }
            logger.error("\u65e5\u5fd7\u6301\u4e45\u5316\u65b9\u5f0fElasticsearch\u521d\u59cb\u5316\u5931\u8d25\uff1a", e);
        });
    }

    @Override
    public void saveAccessLog(AccessLogEntity accessLogEntity) {
        this.saveLog(this.indexOfAccessLog(), accessLogEntity, accessLogEntity.getId());
    }

    @Override
    public void saveLoginLog(LoginLogEntity loginLogEntity) {
        this.saveLog(this.indexOfLoginLog(), loginLogEntity, loginLogEntity.getId());
    }

    @Override
    public void removeExpiredAccessLog(LocalDateTime expiredTime) {
        this.removeExpiredLog(this.indexOfAccessLog(), expiredTime);
    }

    @Override
    public void removeExpiredLoginLog(LocalDateTime expiredTime) {
        this.removeExpiredLog(this.indexOfLoginLog(), expiredTime);
    }

    private void saveLog(String indexName, Object logEntity, Long id) {
        try {
            this.elasticsearchClient.create(builder -> builder.index(indexName).document(logEntity).id(id.toString()));
        }
        catch (IOException e) {
            logger.error("\u4fdd\u5b58\u65e5\u5fd7\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private void removeExpiredLog(String indexName, LocalDateTime expiredTime) {
        Function<DeleteByQueryRequest.Builder, ObjectBuilder> deleteRequest = builder -> builder.index(indexName, new String[0]).query(query -> query.range(range -> range.field("requestTime").lte(JsonData.of((Object)expiredTime))));
        try {
            this.elasticsearchClient.deleteByQuery(deleteRequest);
        }
        catch (IOException e) {
            logger.error("Elasticsearch\u5220\u9664\u8fc7\u671f\u7d22\u5f15\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private void checkIndexExists() {
        HashMap<String, TypeMapping> indexMap = new HashMap<String, TypeMapping>(4);
        indexMap.put(this.indexOfAccessLog(), this.mappingOfAccessLog());
        indexMap.put(this.indexOfLoginLog(), this.mappingOfLoginLog());
        for (Map.Entry entry : indexMap.entrySet()) {
            try {
                boolean exists = this.elasticsearchClient.indices().exists(builder -> builder.index((String)entry.getKey(), new String[0])).value();
                if (exists) {
                    continue;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("\u68c0\u67e5\u65e5\u5fd7\u7d22\u5f15\u5f02\u5e38\uff1a", e);
            }
            if (!this.config.getAutoCreate().booleanValue()) {
                throw new IllegalStateException("\u65e5\u5fd7\u7d22\u5f15" + (String)entry.getKey() + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u521b\u5efa\uff01");
            }
            try {
                CreateIndexResponse resp = this.elasticsearchClient.indices().create(builder -> builder.index((String)entry.getKey()).mappings((TypeMapping)entry.getValue()));
                if (resp.acknowledged()) continue;
                throw new IllegalStateException("\u65e5\u5fd7\u7d22\u5f15" + (String)entry.getKey() + "\u521b\u5efa\u5931\u8d25");
            }
            catch (IOException e) {
                throw new RuntimeException("\u521b\u5efa\u65e5\u5fd7\u7d22\u5f15\u5f02\u5e38\uff1a", e);
            }
        }
    }

    private String indexOfAccessLog() {
        return this.config.getIndexPrefix() + "access";
    }

    private String indexOfLoginLog() {
        return this.config.getIndexPrefix() + "login";
    }

    private TypeMapping.Builder mappingOfBase() {
        return new TypeMapping.Builder().properties("id", property -> property.long_(p -> (ObjectBuilder)p.index(Boolean.valueOf(true)))).properties("requestTime", property -> property.date(p -> p.index(Boolean.valueOf(true)).format("uuuu-MM-dd HH:mm:ss"))).properties("responseTime", property -> property.date(p -> p.format("uuuu-MM-dd HH:mm:ss"))).properties("cost", property -> property.long_(p -> (ObjectBuilder)p.index(Boolean.valueOf(true)))).properties("platformCode", property -> property.keyword(p -> p.index(Boolean.valueOf(true)))).properties("clientId", property -> property.text(p -> p)).properties("userId", property -> property.long_(p -> p)).properties("username", property -> property.keyword(p -> p)).properties("browser", property -> property.text(p -> p)).properties("userAgent", property -> property.text(p -> p)).properties("method", property -> property.text(p -> p)).properties("reqContentType", property -> property.text(p -> p)).properties("uri", property -> property.text(p -> p)).properties("operation", property -> property.text(p -> p)).properties("reqIp", property -> property.text(p -> p)).properties("reqOuterIp", property -> property.text(p -> p)).properties("address", property -> property.text(p -> p)).properties("queryParams", property -> property.text(p -> p)).properties("requestBodyTxt", property -> property.text(p -> p)).properties("serverInstance", property -> property.keyword(p -> p.index(Boolean.valueOf(true)))).properties("serverInstanceIp", property -> property.text(p -> p)).properties("appCode", property -> property.keyword(p -> p.index(Boolean.valueOf(true)))).properties("resultCode", property -> property.integer(p -> p)).properties("success", property -> property.boolean_(p -> p)).properties("msg", property -> property.text(p -> p)).properties("com/elitescloud/cloudt/common/exception", property -> property.text(p -> p));
    }

    private TypeMapping mappingOfAccessLog() {
        return this.mappingOfBase().properties("traceId", property -> property.text(p -> p)).properties("threadId", property -> property.text(p -> p)).properties("responseBodyTxt", property -> property.text(p -> p)).build();
    }

    private TypeMapping mappingOfLoginLog() {
        return this.mappingOfBase().properties("loginMethod", property -> property.text(p -> p)).properties("loginType", property -> property.text(p -> p)).properties("terminal", property -> property.text(p -> p)).properties("userDetail", property -> property.text(p -> p)).build();
    }
}

