/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.log.service;

import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.log.common.OperationTypeEnum;
import com.elitescloud.boot.log.model.bo.OperationLogDTO;
import com.elitescloud.boot.log.service.OperationLogMqMessageDefaultServiceImpl;
import com.elitescloud.boot.log.service.OperationLogMqMessageService;
import com.elitescloud.boot.wrapper.RedisWrapper;
import com.elitescloud.cloudt.common.base.ApiResult;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.springframework.core.env.Environment;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.connection.stream.ObjectRecord;
import org.springframework.data.redis.connection.stream.Record;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.RedisTemplate;

public class OperationLogRedisMqMessageServiceImpl
implements OperationLogMqMessageService {
    private static final Logger logger = CloudtBootLoggerFactory.LOG_OPERATION.getLogger(OperationLogRedisMqMessageServiceImpl.class);
    private final Environment environment;
    private final TaskExecutor taskExecutor;
    private final RedisTemplate<String, String> redisTemplate;
    private final RedisWrapper redisWrapper;

    public OperationLogRedisMqMessageServiceImpl(Environment environment, TaskExecutor taskExecutor, RedisTemplate<String, String> redisTemplate, RedisWrapper redisWrapper) {
        this.environment = environment;
        this.taskExecutor = taskExecutor;
        this.redisTemplate = redisTemplate;
        this.redisWrapper = redisWrapper;
    }

    @Override
    public ApiResult<String> sendSyncOperationLogMqMessage(OperationLogDTO operationLogDTO) {
        try {
            this.checkOperationLog(operationLogDTO);
            if (this.sendMessage(operationLogDTO)) {
                return ApiResult.ok();
            }
            return ApiResult.fail((String)"\u53d1\u9001\u8fd4\u56de\u5931\u8d25\u72b6\u6001");
        }
        catch (Exception e) {
            logger.error("\u64cd\u4f5c\u65e5\u5fd7\u5f02\u5e38\uff1a{}  {}", (Object)e.getMessage(), (Object)operationLogDTO);
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @Override
    public ApiResult<String> sendAsyncOperationLogMqMessage(OperationLogDTO operationLogDTO) {
        try {
            this.checkOperationLog(operationLogDTO);
            CompletableFuture.runAsync(() -> this.sendMessage(operationLogDTO), (Executor)this.taskExecutor);
            return ApiResult.ok();
        }
        catch (Exception e) {
            logger.error("\u64cd\u4f5c\u65e5\u5fd7\u5f02\u5e38\uff1a{}  {}", (Object)e.getMessage(), (Object)operationLogDTO);
            return ApiResult.fail((String)e.getMessage());
        }
    }

    private boolean sendMessage(OperationLogDTO operationLogDTO) {
        boolean isSuccess;
        String topicPrefix = this.environment.getProperty("elitesland.log.topic.prefix", "");
        String messageKey = String.valueOf(UUID.randomUUID());
        operationLogDTO.setExt3(topicPrefix + "YST_OPERATION_LOG_TOPIC_" + messageKey);
        operationLogDTO.setExt2(messageKey);
        ObjectRecord record = StreamRecords.newRecord().in((Object)(topicPrefix + "YST_OPERATION_LOG_TOPIC")).ofObject((Object)operationLogDTO).withId(RecordId.autoGenerate());
        RecordId recordId = (RecordId)this.redisWrapper.apply(() -> this.redisTemplate.opsForStream().add((Record)record), null);
        boolean bl = isSuccess = recordId != null;
        if (isSuccess) {
            if (logger.isDebugEnabled()) {
                logger.debug("\u64cd\u4f5c\u65e5\u5fd7\u6d88\u606f\u53d1\u9001\uff1a{}-{}--{}", new Object[]{isSuccess, operationLogDTO, recordId});
            }
        } else {
            logger.error("\u64cd\u4f5c\u65e5\u5fd7\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a{}-{}--{}", new Object[]{isSuccess, operationLogDTO, recordId});
        }
        return isSuccess;
    }

    @Override
    public OperationLogDTO quickNewOperationLogDTO(Enum businessType, String businessParam, com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum operationType, String operationDescription) {
        if (!"BusinessObjectEnum".equals(businessType.getClass().getSimpleName())) {
            logger.error("\u547d\u540d\u9519\u8bef\uff0c\u5bf9\u8c61\u7c7b\u578b\u679a\u4e3e\u7edf\u4e00\u547d\u540d\uff1aBusinessObjectEnum");
        }
        return this.quickNewOperationLogDTO(businessType.name(), businessParam, operationType, operationDescription);
    }

    @Override
    public OperationLogDTO quickNewOperationLogDTO(Enum businessType, String businessParam, OperationTypeEnum operationType, String operationDescription) {
        if (!"BusinessObjectEnum".equals(businessType.getClass().getSimpleName())) {
            logger.error("\u547d\u540d\u9519\u8bef\uff0c\u5bf9\u8c61\u7c7b\u578b\u679a\u4e3e\u7edf\u4e00\u547d\u540d\uff1aBusinessObjectEnum");
        }
        return this.quickNewOperationLogDTO(businessType.name(), businessParam, operationType, operationDescription);
    }

    @Override
    public OperationLogDTO quickNewOperationLogDTO(String businessType, String businessParam, com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum operationType, String operationDescription) {
        OperationLogDTO operationLogDTO = OperationLogMqMessageDefaultServiceImpl.getOperationLogDTO(businessType, businessParam, operationType, operationDescription, this.environment);
        return operationLogDTO;
    }

    @Override
    public OperationLogDTO quickNewOperationLogDTO(String businessType, String businessParam, OperationTypeEnum operationType, String operationDescription) {
        OperationLogDTO operationLogDTO = OperationLogMqMessageDefaultServiceImpl.getOperationLogDTO(businessType, businessParam, operationType, operationDescription, this.environment);
        return operationLogDTO;
    }
}

