/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.log.common.filter;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;

@Plugin(name="LoggerNameFilter", category="Core", elementType="filter", printObject=true)
public class LoggerNameFilter
extends AbstractFilter {
    private final Set<String> targetNames;
    private final boolean withChildren;

    public LoggerNameFilter(Filter.Result onMatch, Filter.Result onMismatch, Set<String> targetNames) {
        super(onMatch, onMismatch);
        this.targetNames = targetNames;
        this.withChildren = true;
    }

    public LoggerNameFilter(Filter.Result onMatch, Filter.Result onMismatch, Set<String> targetNames, boolean withChildren) {
        super(onMatch, onMismatch);
        this.targetNames = targetNames;
        this.withChildren = withChildren;
    }

    @PluginFactory
    public static LoggerNameFilter createFilter(@PluginAttribute(value="loggerNames") String loggerNames, @PluginAttribute(value="onMatch") Filter.Result onMatch, @PluginAttribute(value="onMismatch") Filter.Result onMismatch, @PluginAttribute(value="withChildren", defaultBoolean=true) Boolean withChildren) {
        Set<String> targetNames;
        Set<String> set = targetNames = CharSequenceUtil.isBlank((CharSequence)loggerNames) ? Collections.emptySet() : Arrays.stream(loggerNames.split(",")).collect(Collectors.toSet());
        if (onMatch == null) {
            onMatch = Filter.Result.ACCEPT;
        }
        if (onMismatch == null) {
            onMismatch = Filter.Result.DENY;
        }
        if (withChildren == null) {
            withChildren = true;
        }
        return new LoggerNameFilter(onMatch, onMismatch, targetNames, withChildren);
    }

    public Filter.Result filter(LogEvent event) {
        String loggerName = event.getLoggerName();
        if (loggerName == null || CollUtil.isEmpty(this.targetNames)) {
            return this.getOnMismatch();
        }
        if (this.targetNames.contains(loggerName) || this.targetNames.contains("*")) {
            return this.getOnMatch();
        }
        if (this.withChildren) {
            for (String targetName : this.targetNames) {
                if (!loggerName.startsWith(targetName + ".")) continue;
                return this.getOnMatch();
            }
        }
        return this.getOnMismatch();
    }
}

