/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.log.provider.storage;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.log.LogProperties;
import com.elitescloud.boot.log.config.LogRepositoryProperties;
import com.elitescloud.boot.log.model.entity.AccessLogEntity;
import com.elitescloud.boot.log.model.entity.BaseRequestLogEntity;
import com.elitescloud.boot.log.model.entity.LoginLogEntity;
import com.elitescloud.boot.log.provider.storage.AbstractLogStorage;
import com.zaxxer.hikari.HikariDataSource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class DatabaseStorage
extends AbstractLogStorage {
    private static final Logger logger = CloudtBootLoggerFactory.LOG.getLogger(DatabaseStorage.class);
    private static final String TABLE_ACCESS_LOG = "sys_access_log";
    private static final String TABLE_LOGIN_LOG = "sys_login_log";
    private static final String SQL_INSERT_ACCESS_LOG = "insert into sys_access_log(id, request_time, response_time, cost, platform_code, client_id, user_id, username, browser, user_agent, method, req_content_type, uri, operation, req_ip, req_outer_ip, address, query_params, request_body_txt, server_instance, server_instance_ip, app_code, result_code, success, msg, exception, trace_id, thread_id, response_body_txt) values (:id, :request_time, :response_time, :cost, :platform_code, :client_id, :user_id, :username, :browser, :user_agent, :method, :req_content_type, :uri, :operation, :req_ip, :req_outer_ip, :address, :query_params, :request_body_txt, :server_instance, :server_instance_ip, :app_code, :result_code, :success, :msg, :exception, :trace_id, :thread_id, :response_body_txt)";
    private static final String SQL_INSERT_LOGIN_LOG = "insert into sys_login_log(id, request_time, response_time, cost, platform_code, client_id, user_id, username, browser, user_agent, method, req_content_type, uri, operation, req_ip, req_outer_ip, address, query_params, request_body_txt, server_instance, server_instance_ip, app_code, result_code, success, msg, exception, login_method, login_type, terminal, user_detail) values (:id, :request_time, :response_time, :cost, :platform_code, :client_id, :user_id, :username, :browser, :user_agent, :method, :req_content_type, :uri, :operation, :req_ip, :req_outer_ip, :address, :query_params, :request_body_txt, :server_instance, :server_instance_ip, :app_code, :result_code, :success, :msg, :exception, :login_method, :login_type, :terminal, :user_detail)";
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final ArrayBlockingQueue<MapSqlParameterSource> accessLogQueue = new ArrayBlockingQueue(204800);

    public DatabaseStorage(LogProperties logProperties) {
        super(logProperties);
        this.jdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)this.buildJdbcTemplate());
        this.buildThreadToSaveAccessLog();
    }

    @Override
    public void saveAccessLog(AccessLogEntity accessLogEntity) {
        MapSqlParameterSource param = this.accessLog2Map(accessLogEntity);
        boolean result = this.accessLogQueue.offer(param);
        if (result) {
            return;
        }
        logger.error("\u63a5\u53e3\u8bbf\u95ee\u65e5\u5fd7\u6301\u4e45\u5316\u961f\u5217\u5df2\u6ee1\uff01");
    }

    @Override
    public void saveLoginLog(LoginLogEntity loginLogEntity) {
        MapSqlParameterSource params = this.loginLog2Map(loginLogEntity);
        this.jdbcTemplate.update(SQL_INSERT_LOGIN_LOG, (SqlParameterSource)params);
    }

    @Override
    public void removeExpiredAccessLog(LocalDateTime expiredTime) {
        this.jdbcTemplate.update("delete from sys_access_log where request_time < :expiredTime", Map.of("expiredTime", expiredTime));
    }

    @Override
    public void removeExpiredLoginLog(LocalDateTime expiredTime) {
        this.jdbcTemplate.update("delete from sys_login_log where request_time < :expiredTime", Map.of("expiredTime", expiredTime));
    }

    private JdbcTemplate buildJdbcTemplate() {
        return new JdbcTemplate(this.buildDatasource());
    }

    private DataSource buildDatasource() {
        LogRepositoryProperties.Database database = this.logProperties.getRepository().getDatabase();
        HikariDataSource dataSource = new HikariDataSource();
        dataSource.setJdbcUrl((String)Assert.notBlank((CharSequence)database.getUrl(), (String)"\u65e5\u5fd7\u914d\u7f6e\u7684\u6570\u636e\u5e93url\u4e3a\u7a7a", (Object[])new Object[0]));
        dataSource.setDriverClassName((String)Assert.notBlank((CharSequence)database.getDriverClassName(), (String)"\u65e5\u5fd7\u914d\u7f6e\u7684\u6570\u636e\u5e93\u9a71\u52a8\u4e3a\u7a7a", (Object[])new Object[0]));
        dataSource.setUsername((String)Assert.notBlank((CharSequence)database.getUsername(), (String)"\u65e5\u5fd7\u914d\u7f6e\u7684\u6570\u636e\u5e93\u7528\u6237\u540d\u4e3a\u7a7a", (Object[])new Object[0]));
        dataSource.setPassword((String)Assert.notBlank((CharSequence)database.getPassword(), (String)"\u65e5\u5fd7\u914d\u7f6e\u7684\u6570\u636e\u5e93\u5bc6\u7801\u4e3a\u7a7a", (Object[])new Object[0]));
        return dataSource;
    }

    private MapSqlParameterSource accessLog2Map(AccessLogEntity entity) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        this.fillBaseRequestLogEntity(parameterSource, entity);
        parameterSource.addValue("trace_id", (Object)entity.getTraceId());
        parameterSource.addValue("thread_id", (Object)entity.getThreadId());
        parameterSource.addValue("response_body_txt", (Object)entity.getResponseBodyTxt());
        return parameterSource;
    }

    private MapSqlParameterSource loginLog2Map(LoginLogEntity entity) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        this.fillBaseRequestLogEntity(parameterSource, entity);
        parameterSource.addValue("login_method", (Object)entity.getLoginMethod());
        parameterSource.addValue("login_type", (Object)entity.getLoginType());
        parameterSource.addValue("terminal", (Object)entity.getTerminal());
        parameterSource.addValue("user_detail", (Object)entity.getUserDetail());
        return parameterSource;
    }

    private void fillBaseRequestLogEntity(MapSqlParameterSource parameterSource, BaseRequestLogEntity entity) {
        parameterSource.addValue("id", (Object)entity.getId());
        parameterSource.addValue("request_time", (Object)entity.getRequestTime());
        parameterSource.addValue("response_time", (Object)entity.getResponseTime());
        parameterSource.addValue("cost", (Object)entity.getCost());
        parameterSource.addValue("platform_code", (Object)entity.getPlatformCode());
        parameterSource.addValue("client_id", (Object)entity.getClientId());
        parameterSource.addValue("user_id", (Object)entity.getUserId());
        parameterSource.addValue("username", (Object)entity.getUsername());
        parameterSource.addValue("browser", (Object)entity.getBrowser());
        parameterSource.addValue("user_agent", (Object)entity.getUserAgent());
        parameterSource.addValue("method", (Object)entity.getMethod());
        parameterSource.addValue("req_content_type", (Object)entity.getReqContentType());
        parameterSource.addValue("uri", (Object)entity.getUri());
        parameterSource.addValue("operation", (Object)entity.getOperation());
        parameterSource.addValue("req_ip", (Object)entity.getReqIp());
        parameterSource.addValue("req_outer_ip", (Object)entity.getReqOuterIp());
        parameterSource.addValue("address", (Object)entity.getAddress());
        parameterSource.addValue("query_params", (Object)entity.getQueryParams());
        parameterSource.addValue("request_body_txt", (Object)entity.getRequestBodyTxt());
        parameterSource.addValue("server_instance", (Object)entity.getServerInstance());
        parameterSource.addValue("server_instance_ip", (Object)entity.getServerInstanceIp());
        parameterSource.addValue("app_code", (Object)entity.getAppCode());
        parameterSource.addValue("result_code", (Object)entity.getResultCode());
        parameterSource.addValue("success", (Object)entity.getSuccess());
        parameterSource.addValue("msg", (Object)entity.getMsg());
        parameterSource.addValue("com/elitescloud/cloudt/common/exception", (Object)entity.getException());
    }

    private void buildThreadToSaveAccessLog() {
        Thread thread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        this.executeSaveAccessLog();
                        TimeUnit.SECONDS.sleep(this.logProperties.getAccessLog().getPersistenceRate().toSeconds());
                    }
                }
                catch (Exception e) {
                    logger.error("\u6301\u4e45\u5316\u63a5\u53e3\u65e5\u5fd7\u7ebf\u7a0b\u5f02\u5e38\uff1a", (Throwable)e);
                    continue;
                }
                break;
            }
        });
        thread.setDaemon(true);
        thread.setName("cloudt-accessLog-persistence");
        thread.start();
    }

    private void executeSaveAccessLog() {
        int max = (Integer)ObjectUtil.defaultIfNull((Object)this.logProperties.getAccessLog().getMax(), (Object)1024);
        ArrayList<MapSqlParameterSource> sourceList = new ArrayList<MapSqlParameterSource>(max);
        MapSqlParameterSource element = null;
        for (int size = 0; !(size >= max && this.accessLogQueue.isEmpty() || (element = this.accessLogQueue.poll()) == null); ++size) {
            sourceList.add(element);
        }
        if (!sourceList.isEmpty()) {
            this.jdbcTemplate.batchUpdate(SQL_INSERT_ACCESS_LOG, (SqlParameterSource[])sourceList.toArray(MapSqlParameterSource[]::new));
        }
    }
}

