/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.nacos.service;

import com.alibaba.cloud.ai.mcp.nacos.service.NacosMcpSubscriber;
import com.alibaba.cloud.ai.mcp.nacos.service.model.NacosMcpServerEndpoint;
import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.ai.model.mcp.McpEndpointInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpEndpointSpec;
import com.alibaba.nacos.api.ai.model.mcp.McpServerBasicInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServiceRef;
import com.alibaba.nacos.api.ai.model.mcp.McpToolSpecification;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.maintainer.client.ai.AiMaintainerFactory;
import com.alibaba.nacos.maintainer.client.ai.AiMaintainerService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosMcpOperationService {
    private static final Logger logger = LoggerFactory.getLogger(NacosMcpOperationService.class);
    private final AiMaintainerService aiMaintainerService;
    private final NamingService namingService;
    private final String namespace;
    private final Map<String, List<NacosMcpSubscriber>> subscribers;

    public NacosMcpOperationService(Properties nacosProperties) throws NacosException {
        this.aiMaintainerService = AiMaintainerFactory.createAiMaintainerService((Properties)nacosProperties);
        this.namingService = NacosFactory.createNamingService((Properties)nacosProperties);
        this.namespace = nacosProperties.getProperty("namespace", "public");
        this.subscribers = new ConcurrentHashMap<String, List<NacosMcpSubscriber>>();
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(1, r -> {
            Thread t = new Thread(r);
            t.setName("nacos-mcp-operation-service");
            t.setDaemon(true);
            return t;
        });
        executorService.scheduleWithFixedDelay(this::getServerChange, 30L, 30L, TimeUnit.SECONDS);
    }

    private void getServerChange() {
        for (Map.Entry<String, List<NacosMcpSubscriber>> entry : this.subscribers.entrySet()) {
            String mcpNameAndVersion = entry.getKey();
            List<NacosMcpSubscriber> nacosMcpSubscribers = entry.getValue();
            try {
                McpServerDetailInfo mcpServerDetailInfo = this.getServerDetail(mcpNameAndVersion);
                if (mcpServerDetailInfo == null) continue;
                for (NacosMcpSubscriber nacosMcpSubscriber : nacosMcpSubscribers) {
                    nacosMcpSubscriber.receive(mcpServerDetailInfo);
                }
            }
            catch (Exception e) {
                logger.error("getServerChange error", (Throwable)e);
            }
        }
    }

    public NacosMcpServerEndpoint getServerEndpoint(String mcpNameAndVersion) throws NacosException {
        if (mcpNameAndVersion == null) {
            throw new IllegalArgumentException("mcpNameAndVersion must not be null");
        }
        McpServerDetailInfo mcpServerDetailInfo = this.getServerDetail(mcpNameAndVersion);
        if (mcpServerDetailInfo == null) {
            return null;
        }
        ArrayList<McpEndpointInfo> mcpEndpointInfoList = mcpServerDetailInfo.getBackendEndpoints() == null ? new ArrayList() : mcpServerDetailInfo.getBackendEndpoints();
        String exportPath = mcpServerDetailInfo.getRemoteServerConfig().getExportPath();
        String protocol = mcpServerDetailInfo.getProtocol();
        String realVersion = mcpServerDetailInfo.getVersion();
        return new NacosMcpServerEndpoint(mcpEndpointInfoList, exportPath, protocol, realVersion);
    }

    public McpServerDetailInfo getServerDetail(String mcpNameAndVersion) throws NacosException {
        if (mcpNameAndVersion == null) {
            throw new IllegalArgumentException("mcpNameAndVersion must not be null");
        }
        String[] nameAndVersion = mcpNameAndVersion.strip().split("::");
        String version = null;
        String mcpName = mcpNameAndVersion;
        if (nameAndVersion.length > 2) {
            throw new NacosException(400, "mcpName is invalid");
        }
        if (nameAndVersion.length == 2) {
            version = nameAndVersion[1];
            mcpName = nameAndVersion[0];
        }
        return this.aiMaintainerService.getMcpServerDetail(mcpName);
    }

    public McpServerDetailInfo getServerDetail(String mcpName, String version) throws NacosException {
        if (mcpName == null || version == null) {
            throw new IllegalArgumentException("mcpName must not be null");
        }
        return this.aiMaintainerService.getMcpServerDetail(mcpName);
    }

    public void subscribeNacosMcpServer(String mcpNameAndVersion, NacosMcpSubscriber nacosMcpSubscriber) {
        if (mcpNameAndVersion == null || nacosMcpSubscriber == null) {
            throw new IllegalArgumentException("mcpNameAndVersion and nacosMcpSubscriber must not be null");
        }
        this.subscribers.computeIfAbsent(mcpNameAndVersion, k -> new ArrayList()).add(nacosMcpSubscriber);
    }

    public McpEndpointInfo selectEndpoint(McpServiceRef mcpServiceRef) throws NacosException {
        if (mcpServiceRef == null) {
            throw new IllegalArgumentException("mcpServiceRef must not be null");
        }
        Instance instance = this.namingService.selectOneHealthyInstance(mcpServiceRef.getServiceName(), mcpServiceRef.getGroupName());
        McpEndpointInfo mcpEndpointInfo = new McpEndpointInfo();
        mcpEndpointInfo.setAddress(instance.getIp());
        mcpEndpointInfo.setPort(instance.getPort());
        return mcpEndpointInfo;
    }

    public boolean createMcpServer(String mcpName, McpServerBasicInfo serverSpec, McpToolSpecification toolSpec, McpEndpointSpec endpointSpec) throws NacosException {
        endpointSpec.getData().put("namespaceId", this.namespace);
        return this.aiMaintainerService.createMcpServer(mcpName, serverSpec, toolSpec, endpointSpec);
    }

    public void registerService(String serviceName, String groupName, Instance instance) throws NacosException {
        this.namingService.registerInstance(serviceName, groupName, instance);
    }
}

