/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.ai.util.json.schema;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigPart;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.stream.Stream;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.ai.tool.annotation.ToolParam;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public final class CloudtSpringAiSchemaModule
implements Module {
    private final boolean requiredByDefault;

    public CloudtSpringAiSchemaModule(Option ... options) {
        this.requiredByDefault = Stream.of(options).noneMatch(option -> option == Option.PROPERTY_REQUIRED_FALSE_BY_DEFAULT);
    }

    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        this.applyToConfigBuilder((SchemaGeneratorConfigPart<FieldScope>)builder.forFields());
    }

    private void applyToConfigBuilder(SchemaGeneratorConfigPart<FieldScope> configPart) {
        configPart.withDescriptionResolver(this::resolveDescription);
        configPart.withRequiredCheck(this::checkRequired);
    }

    @Nullable
    private String resolveDescription(MemberScope<?, ?> member) {
        ToolParam toolParamAnnotation = (ToolParam)member.getAnnotationConsideringFieldAndGetter(ToolParam.class);
        if (toolParamAnnotation != null && StringUtils.hasText((String)toolParamAnnotation.description())) {
            return toolParamAnnotation.description();
        }
        ApiModelProperty apiModelPropertyAnnotation = (ApiModelProperty)member.getAnnotationConsideringFieldAndGetter(ApiModelProperty.class);
        if (apiModelPropertyAnnotation != null && StringUtils.hasText((String)apiModelPropertyAnnotation.value())) {
            return apiModelPropertyAnnotation.value();
        }
        return null;
    }

    private boolean checkRequired(MemberScope<?, ?> member) {
        ToolParam toolParamAnnotation = (ToolParam)member.getAnnotationConsideringFieldAndGetter(ToolParam.class);
        if (toolParamAnnotation != null) {
            return toolParamAnnotation.required();
        }
        JsonProperty propertyAnnotation = (JsonProperty)member.getAnnotationConsideringFieldAndGetter(JsonProperty.class);
        if (propertyAnnotation != null) {
            return propertyAnnotation.required();
        }
        Schema schemaAnnotation = (Schema)member.getAnnotationConsideringFieldAndGetter(Schema.class);
        if (schemaAnnotation != null) {
            return schemaAnnotation.requiredMode() == Schema.RequiredMode.REQUIRED || schemaAnnotation.requiredMode() == Schema.RequiredMode.AUTO || schemaAnnotation.required();
        }
        Nullable nullableAnnotation = (Nullable)member.getAnnotationConsideringFieldAndGetter(Nullable.class);
        if (nullableAnnotation != null) {
            return false;
        }
        ApiModelProperty apiModelProperty = (ApiModelProperty)member.getAnnotation(ApiModelProperty.class);
        if (apiModelProperty != null) {
            return apiModelProperty.required();
        }
        NotNull notNullAnnotation = (NotNull)member.getAnnotation(NotNull.class);
        if (notNullAnnotation != null) {
            return true;
        }
        NotBlank notBlankAnnotation = (NotBlank)member.getAnnotation(NotBlank.class);
        if (notBlankAnnotation != null) {
            return true;
        }
        NotEmpty notEmptyAnnotation = (NotEmpty)member.getAnnotation(NotEmpty.class);
        if (notEmptyAnnotation != null) {
            return true;
        }
        return this.requiredByDefault;
    }

    public static enum Option {
        PROPERTY_REQUIRED_FALSE_BY_DEFAULT;

    }
}

