/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mcp.config;

import com.alibaba.cloud.ai.mcp.nacos.NacosMcpProperties;
import com.alibaba.cloud.ai.mcp.nacos.registry.NacosMcpRegistryProperties;
import com.alibaba.cloud.ai.mcp.nacos.service.NacosMcpOperationService;
import com.elitescloud.boot.mcp.nacos.registry.NacosMcpRegister;
import com.elitescloud.boot.mcp.support.WebMvcServerTransportProvider;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.mcp.McpToolUtils;
import org.springframework.ai.mcp.server.autoconfigure.McpServerProperties;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;

@ConditionalOnProperty(prefix="elitesland.mcp.server", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class CloudtMcpServerConfig {
    private static final Logger logger = LoggerFactory.getLogger(CloudtMcpServerConfig.class);

    @Bean
    @ConditionalOnMissingBean
    public WebMvcServerTransportProvider webMvcSseServerTransportProvider(ObjectProvider<ObjectMapper> objectMapperProvider, McpServerProperties serverProperties) {
        ObjectMapper objectMapper = (ObjectMapper)objectMapperProvider.getIfAvailable(ObjectMapper::new);
        return new WebMvcServerTransportProvider();
    }

    @Bean
    @ConditionalOnMissingBean
    public McpSchema.ServerCapabilities.Builder capabilitiesBuilder() {
        return McpSchema.ServerCapabilities.builder();
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    public List<McpServerFeatures.SyncToolSpecification> syncTools(ObjectProvider<List<ToolCallback>> toolCalls, List<ToolCallback> toolCallbacksList, McpServerProperties serverProperties) {
        ArrayList<ToolCallback> tools = new ArrayList<ToolCallback>(toolCalls.stream().flatMap(Collection::stream).toList());
        if (!CollectionUtils.isEmpty(toolCallbacksList)) {
            tools.addAll(toolCallbacksList);
        }
        return this.toSyncToolSpecifications(tools, serverProperties);
    }

    @Bean
    public McpSyncServer mcpSyncServer(McpServerTransportProvider transportProvider, McpSchema.ServerCapabilities.Builder capabilitiesBuilder, McpServerProperties serverProperties, ObjectProvider<List<McpServerFeatures.SyncToolSpecification>> tools, List<ToolCallbackProvider> toolCallbackProvider) {
        McpSchema.Implementation serverInfo = new McpSchema.Implementation(serverProperties.getName(), serverProperties.getVersion());
        McpServer.SyncSpecification serverBuilder = McpServer.sync((McpServerTransportProvider)transportProvider).serverInfo(serverInfo);
        if (serverProperties.getCapabilities().isTool()) {
            logger.info("Enable tools capabilities, notification: " + serverProperties.isToolChangeNotification());
            capabilitiesBuilder.tools(Boolean.valueOf(serverProperties.isToolChangeNotification()));
            ArrayList toolSpecifications = new ArrayList(tools.stream().flatMap(Collection::stream).toList());
            List<ToolCallback> providerToolCallbacks = toolCallbackProvider.stream().map(pr -> List.of(pr.getToolCallbacks())).flatMap(Collection::stream).filter(fc -> fc instanceof ToolCallback).map(fc -> fc).toList();
            toolSpecifications.addAll(this.toSyncToolSpecifications(providerToolCallbacks, serverProperties));
            if (!CollectionUtils.isEmpty(toolSpecifications)) {
                serverBuilder.tools(toolSpecifications);
                logger.info("Registered tools: " + toolSpecifications.size());
            }
        }
        serverBuilder.capabilities(capabilitiesBuilder.build());
        serverBuilder.instructions(serverProperties.getInstructions());
        serverBuilder.requestTimeout(serverProperties.getRequestTimeout());
        return serverBuilder.build();
    }

    @Bean
    public NacosMcpRegister nacosMcpRegister(NacosMcpOperationService nacosMcpOperationService, McpSyncServer mcpSyncServer, NacosMcpProperties nacosMcpProperties, NacosMcpRegistryProperties nacosMcpRegistryProperties, McpServerProperties mcpServerProperties) {
        return new NacosMcpRegister(nacosMcpOperationService, mcpSyncServer.getAsyncServer(), nacosMcpProperties, nacosMcpRegistryProperties, mcpServerProperties, "http");
    }

    private List<McpServerFeatures.SyncToolSpecification> toSyncToolSpecifications(List<ToolCallback> tools, McpServerProperties serverProperties) {
        return tools.stream().collect(Collectors.toMap(tool -> tool.getToolDefinition().name(), tool -> tool, (existing, replacement) -> existing)).values().stream().map(tool -> {
            String toolName = tool.getToolDefinition().name();
            MimeType mimeType = serverProperties.getToolResponseMimeType().containsKey(toolName) ? MimeType.valueOf((String)serverProperties.getToolResponseMimeType().get(toolName)) : null;
            return McpToolUtils.toSyncToolSpecification(tool, mimeType);
        }).toList();
    }
}

