/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.content;

import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;

public class Media {
    private static final String NAME_PREFIX = "media-";
    @Nullable
    private final String id;
    private final MimeType mimeType;
    private final Object data;
    private final String name;

    public Media(MimeType mimeType, URI uri) {
        Assert.notNull((Object)mimeType, (String)"MimeType must not be null");
        Assert.notNull((Object)uri, (String)"URI must not be null");
        this.mimeType = mimeType;
        this.id = null;
        this.data = uri.toString();
        this.name = Media.generateDefaultName(mimeType);
    }

    public Media(MimeType mimeType, Resource resource) {
        Assert.notNull((Object)mimeType, (String)"MimeType must not be null");
        Assert.notNull((Object)resource, (String)"Data must not be null");
        try {
            byte[] bytes = resource.getInputStream().readAllBytes();
            this.mimeType = mimeType;
            this.id = null;
            this.data = bytes;
            this.name = Media.generateDefaultName(mimeType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private Media(MimeType mimeType, Object data, @Nullable String id, @Nullable String name) {
        Assert.notNull((Object)mimeType, (String)"MimeType must not be null");
        Assert.notNull((Object)data, (String)"Data must not be null");
        this.mimeType = mimeType;
        this.id = id;
        this.name = name != null ? name : Media.generateDefaultName(mimeType);
        this.data = data;
    }

    private static String generateDefaultName(MimeType mimeType) {
        return NAME_PREFIX + mimeType.getSubtype() + "-" + String.valueOf(UUID.randomUUID());
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public Object getData() {
        return this.data;
    }

    public byte[] getDataAsByteArray() {
        if (this.data instanceof byte[]) {
            return (byte[])this.data;
        }
        throw new IllegalStateException("Media data is not a byte[]");
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static final class Builder {
        private String id;
        private MimeType mimeType;
        private Object data;
        private String name;

        private Builder() {
        }

        public Builder mimeType(MimeType mimeType) {
            Assert.notNull((Object)mimeType, (String)"MimeType must not be null");
            this.mimeType = mimeType;
            return this;
        }

        public Builder data(Resource resource) {
            Assert.notNull((Object)resource, (String)"Data must not be null");
            try {
                this.data = resource.getInputStream().readAllBytes();
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            return this;
        }

        public Builder data(Object data) {
            Assert.notNull((Object)data, (String)"Data must not be null");
            this.data = data;
            return this;
        }

        public Builder data(URI uri) {
            Assert.notNull((Object)uri, (String)"URI must not be null");
            this.data = uri.toString();
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Media build() {
            return new Media(this.mimeType, this.data, this.id, this.name);
        }
    }

    public static class Format {
        public static final MimeType DOC_PDF = MimeType.valueOf((String)"application/pdf");
        public static final MimeType DOC_CSV = MimeType.valueOf((String)"text/csv");
        public static final MimeType DOC_DOC = MimeType.valueOf((String)"application/msword");
        public static final MimeType DOC_DOCX = MimeType.valueOf((String)"application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        public static final MimeType DOC_XLS = MimeType.valueOf((String)"application/vnd.ms-excel");
        public static final MimeType DOC_XLSX = MimeType.valueOf((String)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        public static final MimeType DOC_HTML = MimeType.valueOf((String)"text/html");
        public static final MimeType DOC_TXT = MimeType.valueOf((String)"text/plain");
        public static final MimeType DOC_MD = MimeType.valueOf((String)"text/markdown");
        public static final MimeType VIDEO_MKV = MimeType.valueOf((String)"video/x-matros");
        public static final MimeType VIDEO_MOV = MimeType.valueOf((String)"video/quicktime");
        public static final MimeType VIDEO_MP4 = MimeType.valueOf((String)"video/mp4");
        public static final MimeType VIDEO_WEBM = MimeType.valueOf((String)"video/webm");
        public static final MimeType VIDEO_FLV = MimeType.valueOf((String)"video/x-flv");
        public static final MimeType VIDEO_MPEG = MimeType.valueOf((String)"video/mpeg");
        public static final MimeType VIDEO_MPG = MimeType.valueOf((String)"video/mpeg");
        public static final MimeType VIDEO_WMV = MimeType.valueOf((String)"video/x-ms-wmv");
        public static final MimeType VIDEO_THREE_GP = MimeType.valueOf((String)"video/3gpp");
        public static final MimeType IMAGE_PNG = MimeType.valueOf((String)"image/png");
        public static final MimeType IMAGE_JPEG = MimeType.valueOf((String)"image/jpeg");
        public static final MimeType IMAGE_GIF = MimeType.valueOf((String)"image/gif");
        public static final MimeType IMAGE_WEBP = MimeType.valueOf((String)"image/webp");
    }
}

