/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.nacos;

import com.alibaba.nacos.api.utils.NetUtils;
import com.alibaba.nacos.api.utils.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;

@ConfigurationProperties(prefix="spring.ai.alibaba.mcp.nacos")
public class NacosMcpProperties {
    public static final String CONFIG_PREFIX = "spring.ai.alibaba.mcp.nacos";
    public static final String DEFAULT_NAMESPACE = "public";
    public static final String DEFAULT_ADDRESS = "127.0.0.1:8848";
    private static final Pattern PATTERN = Pattern.compile("-(\\w)");
    private static final Logger log = LoggerFactory.getLogger(NacosMcpProperties.class);
    String namespace = "public";
    String serverAddr;
    String username;
    String password;
    String accessKey;
    String secretKey;
    String endpoint;
    String ip;
    Integer port;
    @Autowired
    @JsonIgnore
    private Environment environment;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    public void setServerAddr(String serverAddr) {
        this.serverAddr = serverAddr;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @PostConstruct
    public void init() throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.ip)) {
            this.ip = NetUtils.localIp();
        }
    }

    public Properties getNacosProperties() {
        Properties properties = new Properties();
        properties.put("serverAddr", Objects.toString(this.serverAddr, ""));
        properties.put("username", Objects.toString(this.username, ""));
        properties.put("password", Objects.toString(this.password, ""));
        properties.put("accessKey", Objects.toString(this.accessKey, ""));
        properties.put("secretKey", Objects.toString(this.secretKey, ""));
        properties.put("namespace", Objects.toString(this.namespace, DEFAULT_NAMESPACE));
        String endpoint = Objects.toString(this.endpoint, "");
        if (endpoint.contains(":")) {
            int index = endpoint.indexOf(":");
            properties.put("endpoint", endpoint.substring(0, index));
            properties.put("endpointPort", endpoint.substring(index + 1));
        } else {
            properties.put("endpoint", endpoint);
        }
        this.enrichNacosConfigProperties(properties);
        if (StringUtils.isEmpty((CharSequence)this.serverAddr) && StringUtils.isEmpty((CharSequence)this.endpoint)) {
            properties.put("serverAddr", DEFAULT_ADDRESS);
        }
        return properties;
    }

    protected void enrichNacosConfigProperties(Properties nacosConfigProperties) {
        if (this.environment == null) {
            return;
        }
        String prefix = CONFIG_PREFIX;
        ConfigurableEnvironment env = (ConfigurableEnvironment)this.environment;
        Map<String, Object> properties = this.getSubProperties((PropertySources)env.getPropertySources(), (PropertyResolver)env, prefix);
        properties.forEach((k, v) -> nacosConfigProperties.putIfAbsent(this.resolveKey((String)k), String.valueOf(v)));
    }

    protected String resolveKey(String key) {
        Matcher matcher = PATTERN.matcher(key);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private Map<String, Object> getSubProperties(PropertySources propertySources, PropertyResolver propertyResolver, String prefix) {
        LinkedHashMap<String, Object> subProperties = new LinkedHashMap<String, Object>();
        for (PropertySource source : propertySources) {
            for (String name : this.getPropertyNames(source)) {
                String subName;
                if (subProperties.containsKey(name) || !name.startsWith(prefix) || subProperties.containsKey(subName = name.substring(prefix.length()))) continue;
                Object value = source.getProperty(name);
                if (value instanceof String) {
                    value = propertyResolver.resolvePlaceholders((String)value);
                }
                subProperties.put(subName, value);
            }
        }
        return Collections.unmodifiableMap(subProperties);
    }

    private String[] getPropertyNames(PropertySource propertySource) {
        String[] propertyNames;
        String[] stringArray = propertyNames = propertySource instanceof EnumerablePropertySource ? ((EnumerablePropertySource)propertySource).getPropertyNames() : null;
        if (propertyNames == null) {
            return new String[0];
        }
        return propertyNames;
    }
}

