/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mcp.nacos.registry;

import cn.hutool.core.util.ObjUtil;
import com.alibaba.cloud.ai.mcp.nacos.NacosMcpProperties;
import com.alibaba.cloud.ai.mcp.nacos.registry.NacosMcpRegistryProperties;
import com.alibaba.cloud.ai.mcp.nacos.registry.utils.JsonSchemaUtils;
import com.alibaba.cloud.ai.mcp.nacos.service.NacosMcpOperationService;
import com.alibaba.nacos.api.ai.model.mcp.McpEndpointSpec;
import com.alibaba.nacos.api.ai.model.mcp.McpServerBasicInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerRemoteServiceConfig;
import com.alibaba.nacos.api.ai.model.mcp.McpServiceRef;
import com.alibaba.nacos.api.ai.model.mcp.McpTool;
import com.alibaba.nacos.api.ai.model.mcp.McpToolMeta;
import com.alibaba.nacos.api.ai.model.mcp.McpToolSpecification;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.utils.StringUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import io.modelcontextprotocol.server.McpAsyncServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.mcp.server.autoconfigure.McpServerProperties;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationListener;

public class NacosMcpRegister
implements ApplicationListener<WebServerInitializedEvent> {
    private static final Logger log = LoggerFactory.getLogger(NacosMcpRegister.class);
    private String type;
    private NacosMcpRegistryProperties nacosMcpRegistryProperties;
    private NacosMcpProperties nacosMcpProperties;
    private McpSchema.Implementation serverInfo;
    private McpAsyncServer mcpAsyncServer;
    private CopyOnWriteArrayList<McpServerFeatures.AsyncToolSpecification> tools;
    private Map<String, McpToolMeta> toolsMeta;
    private McpSchema.ServerCapabilities serverCapabilities;
    private McpServerProperties mcpServerProperties;
    private NacosMcpOperationService nacosMcpOperationService;

    public NacosMcpRegister(NacosMcpOperationService nacosMcpOperationService, McpAsyncServer mcpAsyncServer, NacosMcpProperties nacosMcpProperties, NacosMcpRegistryProperties nacosMcpRegistryProperties, McpServerProperties mcpServerProperties, String type) {
        this.mcpAsyncServer = mcpAsyncServer;
        log.info("Mcp server type: {}", (Object)type);
        this.type = type;
        this.nacosMcpProperties = nacosMcpProperties;
        this.nacosMcpRegistryProperties = nacosMcpRegistryProperties;
        this.nacosMcpOperationService = nacosMcpOperationService;
        this.mcpServerProperties = mcpServerProperties;
        try {
            if (StringUtils.isBlank((CharSequence)this.mcpServerProperties.getVersion())) {
                throw new IllegalArgumentException("mcp server version is blank");
            }
            this.serverInfo = mcpAsyncServer.getServerInfo();
            this.serverCapabilities = mcpAsyncServer.getServerCapabilities();
            Field toolsField = McpAsyncServer.class.getDeclaredField("tools");
            toolsField.setAccessible(true);
            this.tools = (CopyOnWriteArrayList)toolsField.get(mcpAsyncServer);
            this.toolsMeta = new HashMap<String, McpToolMeta>();
            McpServerDetailInfo serverDetailInfo = null;
            try {
                serverDetailInfo = this.nacosMcpOperationService.getServerDetail(this.serverInfo.name(), this.serverInfo.version());
            }
            catch (NacosException e) {
                log.info("can not found McpServer info from nacos,{}", (Object)this.serverInfo.name());
            }
            if (serverDetailInfo != null) {
                try {
                    if (!this.checkCompatible(serverDetailInfo)) {
                        throw new Exception("check mcp server compatible false");
                    }
                }
                catch (Exception e) {
                    log.error("check Tools compatible false", (Throwable)e);
                    throw e;
                }
                if (this.serverCapabilities.tools() != null) {
                    this.updateTools(serverDetailInfo);
                }
                this.subscribe();
                return;
            }
            McpToolSpecification mcpToolSpec = new McpToolSpecification();
            if (this.serverCapabilities.tools() != null) {
                List<McpSchema.Tool> toolsNeedtoRegister = this.tools.stream().map(McpServerFeatures.AsyncToolSpecification::tool).toList();
                String toolsStr = JacksonUtils.toJson(toolsNeedtoRegister);
                List toolsToNacosList = (List)JacksonUtils.toObj((String)toolsStr, (TypeReference)new TypeReference<List<McpTool>>(){});
                mcpToolSpec.setTools(toolsToNacosList);
            }
            McpServerBasicInfo serverBasicInfo = new McpServerBasicInfo();
            serverBasicInfo.setName(this.serverInfo.name());
            serverBasicInfo.setVersion(this.serverInfo.version());
            serverBasicInfo.setDescription(this.serverInfo.name());
            McpEndpointSpec endpointSpec = new McpEndpointSpec();
            if (StringUtils.equals((CharSequence)this.type, (CharSequence)"stdio")) {
                serverBasicInfo.setProtocol("stdio");
            } else if (StringUtils.equals((CharSequence)this.type, (CharSequence)"http")) {
                endpointSpec.setType("REF");
                endpointSpecData = new HashMap<String, String>();
                endpointSpecData.put("serviceName", this.getRegisterServiceName());
                endpointSpecData.put("groupName", this.nacosMcpRegistryProperties.getServiceGroup());
                endpointSpec.setData(endpointSpecData);
                McpServerRemoteServiceConfig remoteServerConfigInfo = new McpServerRemoteServiceConfig();
                String contextPath = this.nacosMcpRegistryProperties.getSseExportContextPath();
                if (StringUtils.isBlank((CharSequence)contextPath)) {
                    contextPath = "";
                }
                remoteServerConfigInfo.setExportPath(contextPath + "/");
                serverBasicInfo.setRemoteServerConfig(remoteServerConfigInfo);
                serverBasicInfo.setProtocol("http");
            } else {
                endpointSpec.setType("REF");
                endpointSpecData = new HashMap();
                endpointSpecData.put("serviceName", this.getRegisterServiceName());
                endpointSpecData.put("groupName", this.nacosMcpRegistryProperties.getServiceGroup());
                endpointSpec.setData(endpointSpecData);
                McpServerRemoteServiceConfig remoteServerConfigInfo = new McpServerRemoteServiceConfig();
                String contextPath = this.nacosMcpRegistryProperties.getSseExportContextPath();
                if (StringUtils.isBlank((CharSequence)contextPath)) {
                    contextPath = "";
                }
                remoteServerConfigInfo.setExportPath(contextPath + this.mcpServerProperties.getSseEndpoint());
                serverBasicInfo.setRemoteServerConfig(remoteServerConfigInfo);
                serverBasicInfo.setProtocol("mcp-sse");
            }
            this.nacosMcpOperationService.createMcpServer(this.serverInfo.name(), serverBasicInfo, mcpToolSpec, endpointSpec);
        }
        catch (Exception e) {
            log.error("Failed to register mcp server to nacos", (Throwable)e);
        }
    }

    private void subscribe() {
        this.nacosMcpOperationService.subscribeNacosMcpServer(this.serverInfo.name() + "::" + this.serverInfo.version(), mcpServerDetailInfo -> {
            if (this.serverCapabilities.tools() != null) {
                this.updateTools(mcpServerDetailInfo);
            }
        });
    }

    private void updateToolDescription(McpServerFeatures.AsyncToolSpecification localToolRegistration, McpSchema.Tool toolInNacos, List<McpServerFeatures.AsyncToolSpecification> toolsRegistrationNeedToUpdate) throws JsonProcessingException {
        Boolean changed = false;
        if (localToolRegistration.tool().description() != null && !localToolRegistration.tool().description().equals(toolInNacos.description())) {
            changed = true;
        }
        String localInputSchemaString = JacksonUtils.toJson((Object)localToolRegistration.tool().inputSchema());
        Map localInputSchemaMap = (Map)JacksonUtils.toObj((String)localInputSchemaString, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Map localProperties = (Map)localInputSchemaMap.get("properties");
        String nacosInputSchemaString = JacksonUtils.toJson((Object)toolInNacos.inputSchema());
        Map nacosInputSchemaMap = (Map)JacksonUtils.toObj((String)nacosInputSchemaString, (TypeReference)new TypeReference<Map<Object, Object>>(){});
        Map nacosProperties = (Map)nacosInputSchemaMap.get("properties");
        for (String key : localProperties.keySet()) {
            if (!nacosProperties.containsKey(key)) continue;
            Map localProperty = (Map)localProperties.get(key);
            Map nacosProperty = (Map)nacosProperties.get(key);
            String localDescription = (String)localProperty.get("description");
            String nacosDescription = (String)nacosProperty.get("description");
            if (nacosDescription == null || nacosDescription.equals(localDescription)) continue;
            localProperty.put("description", nacosDescription);
            changed = true;
        }
        if (changed.booleanValue()) {
            McpSchema.Tool toolNeededUpdate = new McpSchema.Tool(localToolRegistration.tool().name(), toolInNacos.description(), JacksonUtils.toJson((Object)localInputSchemaMap));
            toolsRegistrationNeedToUpdate.add(new McpServerFeatures.AsyncToolSpecification(toolNeededUpdate, localToolRegistration.call()));
        }
    }

    private void updateTools(McpServerDetailInfo mcpServerDetailInfo) {
        try {
            boolean changed = false;
            McpToolSpecification toolSpec = mcpServerDetailInfo.getToolSpec();
            if (toolSpec == null) {
                log.info("get nacos mcp server tools is null,skip tools update");
                return;
            }
            String toolsInNacosStr = JacksonUtils.toJson((Object)toolSpec.getTools());
            List toolsInNacos = (List)JacksonUtils.toObj((String)toolsInNacosStr, (TypeReference)new TypeReference<List<McpSchema.Tool>>(){});
            changed = this.compareToolsMeta(toolSpec.getToolsMeta());
            this.toolsMeta = toolSpec.getToolsMeta();
            ArrayList<McpServerFeatures.AsyncToolSpecification> toolsRegistrationNeedToUpdate = new ArrayList<McpServerFeatures.AsyncToolSpecification>();
            Map<String, McpSchema.Tool> toolsInNacosMap = toolsInNacos.stream().collect(Collectors.toMap(McpSchema.Tool::name, tool -> tool));
            for (McpServerFeatures.AsyncToolSpecification toolRegistration : this.tools) {
                String name = toolRegistration.tool().name();
                if (!toolsInNacosMap.containsKey(name)) continue;
                McpSchema.Tool toolInNacos = toolsInNacosMap.get(name);
                this.updateToolDescription(toolRegistration, toolInNacos, toolsRegistrationNeedToUpdate);
            }
            block3: for (McpServerFeatures.AsyncToolSpecification toolRegistration : toolsRegistrationNeedToUpdate) {
                for (int i = 0; i < this.tools.size(); ++i) {
                    if (!this.tools.get(i).tool().name().equals(toolRegistration.tool().name())) continue;
                    this.tools.set(i, toolRegistration);
                    changed = true;
                    continue block3;
                }
            }
            if (changed) {
                log.info("tools description updated");
            }
            if (changed && this.serverCapabilities.tools().listChanged().booleanValue()) {
                this.mcpAsyncServer.notifyToolsListChanged().block();
            }
        }
        catch (Exception e) {
            log.error("Failed to update tools according to nacos", (Throwable)e);
        }
    }

    public void onApplicationEvent(WebServerInitializedEvent event) {
        if ("stdio".equals(this.type) || !this.nacosMcpRegistryProperties.isServiceRegister()) {
            log.info("No need to register mcp server service to nacos");
            return;
        }
        try {
            int port = event.getWebServer().getPort();
            Instance instance = new Instance();
            instance.setIp(this.nacosMcpProperties.getIp());
            instance.setPort(((Integer)ObjUtil.defaultIfNull((Object)this.nacosMcpProperties.getPort(), (Object)port)).intValue());
            instance.setEphemeral(this.nacosMcpRegistryProperties.isServiceEphemeral());
            this.nacosMcpOperationService.registerService(this.getRegisterServiceName(), this.nacosMcpRegistryProperties.getServiceGroup(), instance);
            log.info("Register mcp server service to nacos successfully");
        }
        catch (NacosException e) {
            log.error("Failed to register mcp server service to nacos", (Throwable)e);
        }
    }

    private boolean checkToolsCompatible(McpServerDetailInfo serverDetailInfo) {
        if (serverDetailInfo.getToolSpec() == null || serverDetailInfo.getToolSpec().getTools() == null || serverDetailInfo.getToolSpec().getTools().isEmpty()) {
            return true;
        }
        McpToolSpecification toolSpec = serverDetailInfo.getToolSpec();
        Map<String, McpTool> toolsInNacos = toolSpec.getTools().stream().collect(Collectors.toMap(McpTool::getName, tool -> tool, (existing, replacement) -> replacement));
        Map<String, McpSchema.Tool> toolsInLocal = this.tools.stream().collect(Collectors.toMap(tool -> tool.tool().name(), McpServerFeatures.AsyncToolSpecification::tool, (existing, replacement) -> replacement));
        if (!toolsInNacos.keySet().equals(toolsInLocal.keySet())) {
            return false;
        }
        for (String toolName : toolsInNacos.keySet()) {
            String jsonSchemaStringInLocal;
            String jsonSchemaStringInNacos = JacksonUtils.toJson((Object)toolsInNacos.get(toolName).getInputSchema());
            if (JsonSchemaUtils.compare(jsonSchemaStringInNacos, jsonSchemaStringInLocal = JacksonUtils.toJson((Object)toolsInLocal.get(toolName).inputSchema()))) continue;
            return false;
        }
        return true;
    }

    private boolean checkCompatible(McpServerDetailInfo serverDetailInfo) {
        return true;
    }

    private boolean isServiceRefSame(McpServiceRef serviceRef) {
        String serviceName = this.getRegisterServiceName();
        if (!StringUtils.equals((CharSequence)serviceRef.getServiceName(), (CharSequence)serviceName)) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)serviceRef.getGroupName(), (CharSequence)this.nacosMcpRegistryProperties.getServiceGroup())) {
            return false;
        }
        return StringUtils.equals((CharSequence)serviceRef.getNamespaceId(), (CharSequence)this.nacosMcpProperties.getNamespace());
    }

    private String getRegisterServiceName() {
        return StringUtils.isBlank((CharSequence)this.nacosMcpRegistryProperties.getServiceName()) ? this.serverInfo.name() : this.nacosMcpRegistryProperties.getServiceName();
    }

    private boolean compareToolsMeta(Map<String, McpToolMeta> toolsMeta) {
        boolean changed = false;
        if (this.toolsMeta == null && toolsMeta != null || this.toolsMeta != null && toolsMeta == null) {
            return true;
        }
        if (this.toolsMeta == null) {
            return false;
        }
        if (!this.toolsMeta.keySet().equals(toolsMeta.keySet())) {
            return false;
        }
        for (String toolName : toolsMeta.keySet()) {
            if (this.toolsMeta.get(toolName).isEnabled() == toolsMeta.get(toolName).isEnabled()) continue;
            changed = true;
            break;
        }
        return changed;
    }
}

