/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mcp.config;

import com.alibaba.cloud.ai.mcp.nacos.NacosMcpProperties;
import com.alibaba.cloud.ai.mcp.nacos.service.NacosMcpOperationService;
import com.alibaba.nacos.api.ai.model.mcp.McpEndpointSpec;
import com.alibaba.nacos.api.ai.model.mcp.McpServerBasicInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpToolMeta;
import com.alibaba.nacos.api.ai.model.mcp.McpToolSpecification;
import com.alibaba.nacos.api.exception.NacosException;
import com.elitescloud.boot.ai.tool.method.CloudtMethodToolCallbackProvider;
import com.elitescloud.boot.mcp.common.McpToolHolder;
import com.elitescloud.boot.mcp.common.McpToolMethodInstance;
import com.elitescloud.boot.mcp.config.CloudtMcpServerProperties;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.annotation.Bean;
import org.springframework.core.MethodParameter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class CloudtMcpToolMethodsConfig
implements BeanFactoryAware {
    private static final Logger logger = LoggerFactory.getLogger(CloudtMcpToolMethodsConfig.class);
    private BeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Bean
    public ToolCallbackProvider mvcToolCallbackProvider(CloudtMcpServerProperties props, RequestMappingHandlerMapping requestMappingHandlerMapping) {
        if (CollectionUtils.isEmpty(props.getTools())) {
            logger.info("no mcp tools");
            return CloudtMethodToolCallbackProvider.builder().toolObjects(new Object[0]).build();
        }
        Map<String, RequestMethod> methodMap = Arrays.stream(RequestMethod.values()).collect(Collectors.toMap(Enum::name, t -> t));
        HashSet toolClass = new HashSet(64);
        ArrayList toolObjects = new ArrayList();
        AtomicInteger toolCounter = new AtomicInteger(0);
        requestMappingHandlerMapping.getHandlerMethods().forEach((key, handlerMethod) -> {
            if (toolCounter.get() == props.getTools().size()) {
                return;
            }
            for (CloudtMcpServerProperties.McpTool tool : props.getTools()) {
                String toolDescription;
                if (!StringUtils.hasText((String)tool.getUrl()) || !StringUtils.hasText((String)tool.getUrlMethod())) {
                    logger.error("mcpTool\u914d\u7f6e\u7684url\u548curlMethod\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5ffd\u7565");
                    continue;
                }
                RequestMethod method = (RequestMethod)methodMap.get(tool.getUrlMethod());
                if (method == null || !key.getMethodsCondition().getMethods().contains(method) || !key.getPatternValues().contains(tool.getUrl())) continue;
                Tool annoTool = (Tool)handlerMethod.getMethodAnnotation(Tool.class);
                String toolName = tool.getName();
                if (!StringUtils.hasText((String)toolName)) {
                    String string = toolName = annoTool != null && StringUtils.hasText((String)annoTool.name()) ? annoTool.name() : handlerMethod.getMethod().getName();
                }
                if (!StringUtils.hasText((String)(toolDescription = tool.getDescription()))) {
                    if (annoTool != null) {
                        toolDescription = annoTool.description();
                    }
                    if (!StringUtils.hasText((String)toolDescription)) {
                        ApiOperation apiOperation = (ApiOperation)handlerMethod.getMethodAnnotation(ApiOperation.class);
                        String string = toolDescription = apiOperation == null ? null : apiOperation.value();
                    }
                    if (!StringUtils.hasText((String)toolDescription)) {
                        toolDescription = toolName;
                    }
                }
                McpToolMethodInstance.ParamPosition paramPosition = null;
                if (method == RequestMethod.GET) {
                    paramPosition = McpToolMethodInstance.ParamPosition.QUERY;
                } else {
                    for (MethodParameter methodParameter : handlerMethod.getMethodParameters()) {
                        if (!methodParameter.hasParameterAnnotation(RequestBody.class)) continue;
                        paramPosition = McpToolMethodInstance.ParamPosition.BODY;
                        break;
                    }
                    if (paramPosition == null) {
                        paramPosition = McpToolMethodInstance.ParamPosition.FORM;
                    }
                }
                McpToolMethodInstance methodInstance = new McpToolMethodInstance();
                methodInstance.setHandlerMethod((HandlerMethod)handlerMethod);
                methodInstance.setToolName(toolName);
                methodInstance.setDescription(toolDescription);
                methodInstance.setUrl(tool.getUrl());
                methodInstance.setUrlMethod(tool.getUrlMethod());
                methodInstance.setParamPosition(paramPosition);
                McpToolHolder.registerHandlerMethod(toolName, methodInstance);
                toolCounter.incrementAndGet();
                if (!toolClass.contains(handlerMethod.getBeanType().getName())) {
                    toolClass.add(handlerMethod.getBeanType().getName());
                    toolObjects.add(this.beanFactory.getBean(handlerMethod.getBeanType()));
                }
                return;
            }
        });
        if (toolObjects.isEmpty()) {
            return CloudtMethodToolCallbackProvider.builder().toolObjects(new Object[0]).build();
        }
        return CloudtMethodToolCallbackProvider.builder().toolObjects(toolObjects.toArray()).build();
    }

    @Bean
    public NacosMcpOperationService nacosMcpOperationService(NacosMcpProperties nacosMcpProperties, final CloudtMcpServerProperties props) {
        Properties nacosProperties = nacosMcpProperties.getNacosProperties();
        try {
            return new NacosMcpOperationService(nacosProperties){

                @Override
                public boolean createMcpServer(String mcpName, McpServerBasicInfo serverSpec, McpToolSpecification toolSpec, McpEndpointSpec endpointSpec) throws NacosException {
                    HashMap<String, McpToolMeta> toolsMeta = new HashMap<String, McpToolMeta>();
                    for (Map.Entry<String, McpToolMethodInstance> entry : McpToolHolder.getAll().entrySet()) {
                        McpToolMethodInstance instance = entry.getValue();
                        McpToolMeta toolMeta = new McpToolMeta();
                        toolMeta.setInvokeContext(Collections.emptyMap());
                        toolMeta.setEnabled(true);
                        HashMap templates = new HashMap();
                        toolMeta.setTemplates(templates);
                        HashMap<String, Object> requestTemplate = new HashMap<String, Object>();
                        if (props.isUseJsonGoTemplate()) {
                            templates.put("json-go-template", Map.of("requestTemplate", requestTemplate));
                        } else {
                            templates.put("requestTemplate", requestTemplate);
                        }
                        requestTemplate.put("method", instance.getUrlMethod());
                        requestTemplate.put("url", instance.getUrl());
                        if (instance.getParamPosition() == McpToolMethodInstance.ParamPosition.BODY) {
                            requestTemplate.put("argsToJsonBody", true);
                        } else if (instance.getParamPosition() == McpToolMethodInstance.ParamPosition.FORM) {
                            requestTemplate.put("argsToFormBody", true);
                        } else {
                            requestTemplate.put("argsToUrlParam", true);
                        }
                        toolsMeta.put(entry.getKey(), toolMeta);
                    }
                    toolSpec.setToolsMeta(toolsMeta);
                    return super.createMcpServer(mcpName, serverSpec, toolSpec, endpointSpec);
                }
            };
        }
        catch (NacosException e) {
            throw new RuntimeException(e);
        }
    }
}

