/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.util.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import org.springframework.ai.util.JacksonUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class JsonParser {
    private static final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).disable(new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS})).addModules(JacksonUtils.instantiateAvailableModules())).build();

    private JsonParser() {
    }

    public static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    public static <T> T fromJson(String json, Class<T> type) {
        Assert.notNull((Object)json, (String)"json cannot be null");
        Assert.notNull(type, (String)"type cannot be null");
        try {
            return (T)OBJECT_MAPPER.readValue(json, type);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalStateException("Conversion from JSON to %s failed".formatted(type.getName()), ex);
        }
    }

    public static <T> T fromJson(String json, Type type) {
        Assert.notNull((Object)json, (String)"json cannot be null");
        Assert.notNull((Object)type, (String)"type cannot be null");
        try {
            return (T)OBJECT_MAPPER.readValue(json, OBJECT_MAPPER.constructType(type));
        }
        catch (JsonProcessingException ex) {
            throw new IllegalStateException("Conversion from JSON to %s failed".formatted(type.getTypeName()), ex);
        }
    }

    public static <T> T fromJson(String json, TypeReference<T> type) {
        Assert.notNull((Object)json, (String)"json cannot be null");
        Assert.notNull(type, (String)"type cannot be null");
        try {
            return (T)OBJECT_MAPPER.readValue(json, type);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalStateException("Conversion from JSON to %s failed".formatted(type.getType().getTypeName()), ex);
        }
    }

    public static String toJson(@Nullable Object object) {
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalStateException("Conversion from Object to JSON failed", ex);
        }
    }

    public static Object toTypedObject(Object value, Class<?> type) {
        Assert.notNull((Object)value, (String)"value cannot be null");
        Assert.notNull(type, (String)"type cannot be null");
        Class javaType = ClassUtils.resolvePrimitiveIfNecessary(type);
        if (javaType == String.class) {
            return value.toString();
        }
        if (javaType == Byte.class) {
            return Byte.parseByte(value.toString());
        }
        if (javaType == Integer.class) {
            BigDecimal bigDecimal = new BigDecimal(value.toString());
            return bigDecimal.intValueExact();
        }
        if (javaType == Short.class) {
            return Short.parseShort(value.toString());
        }
        if (javaType == Long.class) {
            BigDecimal bigDecimal = new BigDecimal(value.toString());
            return bigDecimal.longValueExact();
        }
        if (javaType == Double.class) {
            return Double.parseDouble(value.toString());
        }
        if (javaType == Float.class) {
            return Float.valueOf(Float.parseFloat(value.toString()));
        }
        if (javaType == Boolean.class) {
            return Boolean.parseBoolean(value.toString());
        }
        if (javaType.isEnum()) {
            return Enum.valueOf(javaType, value.toString());
        }
        String json = JsonParser.toJson(value);
        return JsonParser.fromJson(json, javaType);
    }
}

