package com.elitescloud.cloudt.messenger.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

/**
 * 消息发送配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/22
 */
@ConfigurationProperties(prefix = CloudtMessengerProperties.CONFIG_PREFIX)
public class CloudtMessengerProperties {
    public static final String CONFIG_PREFIX = "elitesland.messenger";

    /**
     * 服务器地址
     */
    private String serverUrl;

    /**
     * 是否传递认证信息
     */
    private Boolean authorization;

    @NestedConfigurationProperty
    private CloudtMessengerSenderProperties sender = new CloudtMessengerSenderProperties();

    public String getServerUrl() {
        return serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public Boolean getAuthorization() {
        return authorization;
    }

    public void setAuthorization(Boolean authorization) {
        this.authorization = authorization;
    }

    public CloudtMessengerSenderProperties getSender() {
        return sender;
    }

    public void setSender(CloudtMessengerSenderProperties sender) {
        this.sender = sender;
    }
}
