package com.elitescloud.cloudt.messenger.message;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.Assert;

import java.util.Map;

/**
 * 站内信.
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/31
 */
@Data
@ApiModel(description = "站内信")
public class SiteMessageVO extends AbstractMessageSenderVO {
    private static final long serialVersionUID = -6707284955103230026L;

    /**
     * 业务类型
     */
    @ApiModelProperty(name = "业务类型", position = 11)
    private String businessType;

    /**
     * 业务参数
     */
    @ApiModelProperty(value = "业务参数", position = 11)
    private Map<String, String> businessParams;

    @Override
    protected void validate() {
        super.validate();

        Assert.hasText(businessType, "业务类型为空");
    }
}
