package com.elitescloud.cloudt.messenger.message;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.Assert;

import java.util.Map;

/**
 * 短信消息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/22
 */
@Data
@ApiModel(description = "短信消息")
public class SmsMessageVO extends AbstractMessageSenderVO {
    private static final long serialVersionUID = -5122561643808726419L;

    /**
     * 短信签名
     */
    @ApiModelProperty(value = "短信签名", position = 11)
    private String signName;

    /**
     * 是否模板消息
     */
    @ApiModelProperty(value = "是否模板消息", position = 12)
    private Boolean templateMsg;

    /**
     * 模板编码
     */
    @ApiModelProperty(value = "模板编码", position = 13)
    private String templateCode;

    /**
     * 模板参数
     */
    @ApiModelProperty(name = "模板参数", position = 14)
    private Map<String, String> templateParam;

    @Override
    protected void validate() {
        super.validate();

        if (Boolean.TRUE.equals(templateMsg)) {
            Assert.hasText(templateCode, "模板编码为空");
        }
    }
}
