package com.elitescloud.cloudt.messenger.message.builder;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.messenger.message.AbstractMessageSenderVO;
import com.elitescloud.cloudt.messenger.model.MessageAccountVO;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.ArrayList;
import java.util.List;

/**
 * 消息构建器父类.
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/19
 */
public abstract class AbstractMessageBuilder<T extends AbstractMessageBuilder<T, M>, M extends AbstractMessageSenderVO> {

    /**
     * 消息主题
     */
    @NotBlank
    private String subject;

    /**
     * 消息内容
     */
    @NotBlank
    private String content;

    /**
     * 发送人
     */
    private MessageAccountVO sender;

    /**
     * 接收人
     */
    @NotEmpty
    private List<MessageAccountVO> receiverList;

    /**
     * 构建消息
     *
     * @return 消息
     */
    public abstract M build();

    protected final void fillBaseMessage(M messageVO) {
        messageVO.setSubject(Assert.notBlank(this.subject, "消息主题为空"));
        messageVO.setContent(Assert.notBlank(this.content, "发送内容为空"));
        messageVO.setSender(this.sender);
        messageVO.setReceiverList(Assert.notEmpty(this.receiverList, "接收人为空"));
    }

    protected T setSubject(String subject) {
        this.subject = subject;
        return self();
    }

    protected T setContent(String content) {
        this.content = content;
        return self();
    }

    protected T setSender(MessageAccountVO sender) {
        this.sender = sender;
        return self();
    }

    protected T setReceiverList(List<MessageAccountVO> receiverList) {
        this.receiverList = receiverList;
        return self();
    }

    protected T addReceiver(MessageAccountVO receiver) {
        if (receiver == null) {
            return self();
        }
        if (this.receiverList == null) {
            this.receiverList = new ArrayList<>();
        }
        this.receiverList.add(receiver);
        return self();
    }

    protected T self() {
        return (T) this;
    }
}
