package com.elitescloud.cloudt.messenger.message.builder;

import com.elitescloud.cloudt.messenger.message.SiteMessageVO;
import com.elitescloud.cloudt.messenger.model.MessageAccountVO;
import io.swagger.annotations.ApiModelProperty;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 站内信构建器.
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/19
 */
public class SiteMessageBuilder extends AbstractMessageBuilder<SiteMessageBuilder, SiteMessageVO> {

    /**
     * 业务类型
     */
    @ApiModelProperty(name = "业务类型", position = 11)
    private String businessType;

    /**
     * 业务参数
     */
    protected Map<String, String> businessParams;

    @Override
    public SiteMessageVO build() {
        SiteMessageVO messageVO = new SiteMessageVO();
        messageVO.setBusinessType(this.businessType);
        messageVO.setBusinessParams(this.businessParams);

        super.fillBaseMessage(messageVO);
        return messageVO;
    }

    @Override
    public SiteMessageBuilder setSubject(String subject) {
        super.setSubject(subject);
        return self();
    }

    @Override
    public SiteMessageBuilder setContent(String content) {
        super.setContent(content);
        return self();
    }

    @Override
    public SiteMessageBuilder setSender(MessageAccountVO sender) {
        super.setSender(sender);
        return self();
    }

    @Override
    public SiteMessageBuilder setReceiverList(List<MessageAccountVO> receiverList) {
        super.setReceiverList(receiverList);
        return self();
    }

    public SiteMessageBuilder setBusinessType(String businessType) {
        this.businessType = businessType;
        return self();
    }

    public SiteMessageBuilder setBusinessParams(Map<String, String> businessParams) {
        this.businessParams = businessParams;
        return self();
    }

    public SiteMessageBuilder addBusinessParams(String key, String value) {
        if (this.businessParams == null) {
            this.businessParams = new HashMap<>();
        }
        this.businessParams.put(key, value);
        return self();
    }

    public SiteMessageBuilder addBusinessParams(Map<String, String> businessParams) {
        if (businessParams == null) {
            return self();
        }
        if (this.businessParams == null) {
            this.businessParams = new HashMap<>();
        }
        this.businessParams.putAll(businessParams);
        return self();
    }

    @Override
    protected SiteMessageBuilder self() {
        return this;
    }
}
