package com.elitescloud.cloudt.messenger.message.builder;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.messenger.message.SmsMessageVO;
import com.elitescloud.cloudt.messenger.model.MessageAccountVO;

import java.util.List;
import java.util.Map;

/**
 * 模板短信消息构建器.
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/19
 */
public class TemplateSmsMessageBuilder extends SmsMessageBuilder {

    /**
     * 短信模板
     */
    private String templateCode;

    /**
     * 模板参数
     */
    private Map<String, String> templateParam;

    @Override
    public SmsMessageVO build() {
        SmsMessageVO messageVO = new SmsMessageVO();
        messageVO.setSignName(this.signName);
        messageVO.setTemplateMsg(true);
        messageVO.setTemplateCode(Assert.notBlank(this.templateCode));
        messageVO.setTemplateParam(Assert.notEmpty(this.templateParam));

        super.fillBaseMessage(messageVO);
        return messageVO;
    }

    @Override
    public TemplateSmsMessageBuilder setSubject(String subject) {
        super.setSubject(subject);
        return self();
    }

    @Override
    public TemplateSmsMessageBuilder setContent(String content) {
        super.setContent(content);
        return self();
    }

    @Override
    public TemplateSmsMessageBuilder setSender(MessageAccountVO sender) {
        super.setSender(sender);
        return self();
    }

    @Override
    public TemplateSmsMessageBuilder setReceiverList(List<MessageAccountVO> receiverList) {
        super.setReceiverList(receiverList);
        return self();
    }

    public TemplateSmsMessageBuilder addReceiver(MessageAccountVO receiver) {
        super.addReceiver(receiver);
        return self();
    }

    @Override
    public TemplateSmsMessageBuilder setSignName(String signName) {
        super.setSignName(signName);
        return self();
    }

    public TemplateSmsMessageBuilder setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
        return self();
    }

    public TemplateSmsMessageBuilder setTemplateParam(Map<String, String> templateParam) {
        this.templateParam = templateParam;
        return self();
    }

    @Override
    protected TemplateSmsMessageBuilder self() {
        return this;
    }
}
