/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.messenger.config;

import com.elitescloud.cloudt.messenger.config.CloudtMessengerProperties;
import com.elitescloud.cloudt.messenger.config.MessengerSenderSupport;
import com.elitescloud.cloudt.messenger.config.support.CurrentUserProvider;
import com.elitescloud.cloudt.messenger.config.support.MessageChannelChoose;
import com.elitescloud.cloudt.messenger.config.support.MessagePropertiesChoose;
import com.elitescloud.cloudt.messenger.message.EmailMessageVO;
import com.elitescloud.cloudt.messenger.message.SiteMessageVO;
import com.elitescloud.cloudt.messenger.message.SmsMessageVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={CloudtMessengerProperties.class})
class CloudtMessengerAutoConfiguration
implements InitializingBean,
ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(CloudtMessengerAutoConfiguration.class);
    private final CloudtMessengerProperties messengerProperties;
    private ApplicationContext applicationContext;

    public CloudtMessengerAutoConfiguration(CloudtMessengerProperties messengerProperties) {
        this.messengerProperties = messengerProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public MessagePropertiesChoose messagePropertiesChooseDefault() {
        return messageVO -> {
            if (messageVO instanceof EmailMessageVO) {
                return this.messengerProperties.getSender().getEmail();
            }
            if (messageVO instanceof SmsMessageVO) {
                if (StringUtils.hasText((String)this.messengerProperties.getSender().getAliyunSms().getAccessKeyId())) {
                    return this.messengerProperties.getSender().getAliyunSms();
                }
            } else {
                if (messageVO instanceof SiteMessageVO) {
                    return this.messengerProperties.getSender().getSiteMessage();
                }
                LOG.warn("\u83b7\u53d6\u6d88\u606f\u5c5e\u6027\u914d\u7f6e\u5f02\u5e38\uff0c\u4e0d\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b\uff1a{}", (Object)messageVO.getClass().getName());
            }
            return null;
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageChannelChoose messageChannelChooseDefault() {
        return messageVO -> {
            if (messageVO instanceof EmailMessageVO) {
                return "email";
            }
            if (messageVO instanceof SmsMessageVO) {
                if (StringUtils.hasText((String)((SmsMessageVO)messageVO).getTemplateCode()) && StringUtils.hasText((String)this.messengerProperties.getSender().getAliyunSms().getAccessKeyId())) {
                    return "sms_aliyun";
                }
                return "sms";
            }
            if (messageVO instanceof SiteMessageVO) {
                return "site";
            }
            LOG.warn("\u83b7\u53d6\u6d88\u606f\u6e20\u9053\u5f02\u5e38\uff0c\u4e0d\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b\uff1a{}", (Object)messageVO.getClass().getName());
            return null;
        };
    }

    public void afterPropertiesSet() throws Exception {
        CurrentUserProvider currentUserProvider;
        MessageChannelChoose messageChannelChoose;
        MessengerSenderSupport.setMessengerProperties(this.messengerProperties);
        MessagePropertiesChoose messagePropertiesChoose = (MessagePropertiesChoose)this.applicationContext.getBeanProvider(MessagePropertiesChoose.class).getIfAvailable();
        if (messagePropertiesChoose != null) {
            MessengerSenderSupport.setMessagePropertiesChoose(messagePropertiesChoose);
        }
        if ((messageChannelChoose = (MessageChannelChoose)this.applicationContext.getBeanProvider(MessageChannelChoose.class).getIfAvailable()) != null) {
            MessengerSenderSupport.setMessageChannelChoose(messageChannelChoose);
        }
        if ((currentUserProvider = (CurrentUserProvider)this.applicationContext.getBeanProvider(CurrentUserProvider.class).getIfAvailable()) != null) {
            MessengerSenderSupport.setCurrentUserProvider(currentUserProvider);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Configuration
    @ConditionalOnClass(value={SecurityContext.class})
    static class SecurityConfig {
        SecurityConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        public CurrentUserProvider currentUserProviderDefault() {
            return () -> {
                Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
                return authentication == null ? null : authentication.getName();
            };
        }
    }
}

