/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.messenger.message;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import com.elitescloud.boot.util.ObjectMapperFactory;
import com.elitescloud.cloudt.messenger.config.MessengerSenderSupport;
import com.elitescloud.cloudt.messenger.config.support.CloudtMessengerSender;
import com.elitescloud.cloudt.messenger.config.support.CurrentUserProvider;
import com.elitescloud.cloudt.messenger.config.support.MessageChannelChoose;
import com.elitescloud.cloudt.messenger.config.support.MessagePropertiesChoose;
import com.elitescloud.cloudt.messenger.model.AbstractMessageVO;
import com.elitescloud.cloudt.messenger.model.ByteMessageAttachmentVO;
import com.elitescloud.cloudt.messenger.model.FileMessageAttachmentVO;
import com.elitescloud.cloudt.messenger.model.MessageAttachmentVO;
import com.elitescloud.cloudt.messenger.model.config.MessagePropertiesVO;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;

public abstract class AbstractMessageSenderVO
extends AbstractMessageVO {
    private static final long serialVersionUID = 270537922564251133L;
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.instance();

    protected void validate() {
    }

    public String send() {
        return this.send(false);
    }

    public String sendSync() {
        return this.send(true);
    }

    protected final void validateAttachment(MessageAttachmentVO attachmentVO) {
        if (attachmentVO instanceof ByteMessageAttachmentVO) {
            ByteMessageAttachmentVO att = (ByteMessageAttachmentVO)attachmentVO;
            Assert.isTrue((boolean)ArrayUtil.isNotEmpty((byte[])att.getFileBytes()), (String)"\u9644\u4ef6\u7684\u5b57\u8282\u6570\u7ec4\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notBlank((CharSequence)att.getShowName(), (String)"\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            return;
        }
        if (attachmentVO instanceof FileMessageAttachmentVO) {
            FileMessageAttachmentVO att = (FileMessageAttachmentVO)attachmentVO;
            Assert.notBlank((CharSequence)att.getFileCode(), (String)"\u9644\u4ef6\u7684\u6587\u4ef6\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
            return;
        }
        throw new IllegalArgumentException("\u6682\u4e0d\u652f\u6301\u7684\u9644\u4ef6\u7c7b\u578b\uff1a" + attachmentVO.getClass().getName());
    }

    private String send(boolean sync) {
        super.setSync(Boolean.valueOf(sync));
        super.setChannelCode(this.detectChannel());
        super.setProperties(this.detectConfigProperties());
        super.setCreator(this.obtainCreator());
        this.validate();
        return CloudtMessengerSender.instance().send(this);
    }

    private String obtainCreator() {
        CurrentUserProvider currentUserProvider = MessengerSenderSupport.getCurrentUserProvider();
        if (currentUserProvider == null) {
            return null;
        }
        return currentUserProvider.currentUsername();
    }

    private String detectChannel() {
        MessageChannelChoose chooseService = MessengerSenderSupport.getMessageChannelChoose();
        if (chooseService == null) {
            return null;
        }
        return chooseService.choose(this);
    }

    private Map<String, Object> detectConfigProperties() {
        MessagePropertiesChoose chooseService = MessengerSenderSupport.getMessagePropertiesChoose();
        if (chooseService == null) {
            return null;
        }
        MessagePropertiesVO prop = chooseService.choose(this);
        if (prop == null) {
            return null;
        }
        return (Map)OBJECT_MAPPER.convertValue((Object)prop, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractMessageSenderVO)) {
            return false;
        }
        AbstractMessageSenderVO other = (AbstractMessageSenderVO)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractMessageSenderVO;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public String toString() {
        return "AbstractMessageSenderVO()";
    }
}

