/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.messenger;

import com.elitescloud.cloudt.messenger.common.MsgReceiveStatusEnum;
import com.elitescloud.cloudt.messenger.config.support.CloudtMessengerSender;
import com.elitescloud.cloudt.messenger.message.builder.AppMessageBuilder;
import com.elitescloud.cloudt.messenger.message.builder.EmailMessageBuilder;
import com.elitescloud.cloudt.messenger.message.builder.RichTextEmailMessageBuilder;
import com.elitescloud.cloudt.messenger.message.builder.SiteMessageBuilder;
import com.elitescloud.cloudt.messenger.message.builder.SmsMessageBuilder;
import com.elitescloud.cloudt.messenger.message.builder.TemplateSmsMessageBuilder;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

public class Messenger {
    private Messenger() {
    }

    public static EmailMessageBuilder email() {
        return new EmailMessageBuilder();
    }

    public static RichTextEmailMessageBuilder richTextEmail() {
        return new RichTextEmailMessageBuilder();
    }

    public static SmsMessageBuilder sms() {
        return new SmsMessageBuilder();
    }

    public static TemplateSmsMessageBuilder templateSms() {
        return new TemplateSmsMessageBuilder();
    }

    public static SiteMessageBuilder siteMessage() {
        return new SiteMessageBuilder();
    }

    public static AppMessageBuilder appMessage() {
        return new AppMessageBuilder();
    }

    public static String querySendStatus(@NotBlank String messageId) {
        return CloudtMessengerSender.instance().getMsgStatus(messageId);
    }

    public static Map<String, String> querySendStatus(@NotEmpty Set<String> messageIds) {
        return CloudtMessengerSender.instance().queryMsgStatus(messageIds);
    }

    public static Map<String, String> queryReceiveStatus(@NotBlank String messageId) {
        return CloudtMessengerSender.instance().queryMsgReceiveStatus(messageId);
    }

    public static Boolean updateReceiveStatus(@NotBlank String messageId, @NotBlank String receiver, @NotNull MsgReceiveStatusEnum receiveStatus) {
        return CloudtMessengerSender.instance().updateMsgReceiveStatus(messageId, receiver, receiveStatus);
    }
}

