package com.elitescloud.cloudt.messenger.config;

import com.elitescloud.coord.messenger.Application;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

/**
 * 消息发送配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/22
 */
@ConfigurationProperties(prefix = CloudtMessengerProperties.CONFIG_PREFIX)
public class CloudtMessengerProperties {
    public static final String CONFIG_PREFIX = "elitesland.messenger";

    /**
     * 服务器地址
     * <p>
     * lb协议时自动从注册中心获取地址，其它协议则直接调用
     */
    private String serverUrl = "lb://" + Application.NAME;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 是否传递认证信息
     */
    private Boolean authorization;

    @NestedConfigurationProperty
    private CloudtMessengerSenderProperties sender = new CloudtMessengerSenderProperties();

    public String getServerUrl() {
        return serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getAuthorization() {
        return authorization;
    }

    public void setAuthorization(Boolean authorization) {
        this.authorization = authorization;
    }

    public CloudtMessengerSenderProperties getSender() {
        return sender;
    }

    public void setSender(CloudtMessengerSenderProperties sender) {
        this.sender = sender;
    }
}
