package com.elitescloud.cloudt.messenger.config;

import com.elitescloud.cloudt.messenger.model.config.AliyunSmsMessagePropertiesVO;
import com.elitescloud.cloudt.messenger.model.config.EmailMessagePropertiesVO;
import com.elitescloud.cloudt.messenger.model.config.JPushAppMessagePropertiesVO;
import com.elitescloud.cloudt.messenger.model.config.SiteMessagePropertiesVO;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import java.io.Serializable;

/**
 * 消息发送者配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/22
 */
public class CloudtMessengerSenderProperties implements Serializable {
    private static final long serialVersionUID = -5530366213233428656L;

    /**
     * 邮件配置
     */
    @NestedConfigurationProperty
    private EmailMessagePropertiesVO email = new EmailMessagePropertiesVO();

    /**
     * 阿里云短信配置
     */
    @NestedConfigurationProperty
    private AliyunSmsMessagePropertiesVO aliyunSms = new AliyunSmsMessagePropertiesVO();

    /**
     * 站内信
     */
    @NestedConfigurationProperty
    private SiteMessagePropertiesVO siteMessage = new SiteMessagePropertiesVO();

    /**
     * 极光推送
     */
    @NestedConfigurationProperty
    private JPushAppMessagePropertiesVO jpush = new JPushAppMessagePropertiesVO();

    public EmailMessagePropertiesVO getEmail() {
        return email;
    }

    public void setEmail(EmailMessagePropertiesVO email) {
        this.email = email;
    }

    public AliyunSmsMessagePropertiesVO getAliyunSms() {
        return aliyunSms;
    }

    public void setAliyunSms(AliyunSmsMessagePropertiesVO aliyunSms) {
        this.aliyunSms = aliyunSms;
    }

    public SiteMessagePropertiesVO getSiteMessage() {
        return siteMessage;
    }

    public void setSiteMessage(SiteMessagePropertiesVO siteMessage) {
        this.siteMessage = siteMessage;
    }

    public JPushAppMessagePropertiesVO getJpush() {
        return jpush;
    }

    public void setJpush(JPushAppMessagePropertiesVO jpush) {
        this.jpush = jpush;
    }
}
