package com.elitescloud.cloudt.messenger.config;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.messenger.config.support.CurrentUserProvider;
import com.elitescloud.cloudt.messenger.config.support.MessageChannelChoose;
import com.elitescloud.cloudt.messenger.config.support.MessagePropertiesChoose;

/**
 * 消息发送支持.
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/23
 */
public class MessengerSenderSupport {

    private static CloudtMessengerProperties messengerProperties;
    private static MessagePropertiesChoose messagePropertiesChoose;
    private static MessageChannelChoose messageChannelChoose;
    private static CurrentUserProvider currentUserProvider;

    public static CloudtMessengerProperties getMessengerProperties() {
        return messengerProperties;
    }

    static void setMessengerProperties(CloudtMessengerProperties messengerProperties) {
        MessengerSenderSupport.messengerProperties = messengerProperties;
        // 校验配置
        validateMessengerProperties();
    }

    public static MessagePropertiesChoose getMessagePropertiesChoose() {
        return messagePropertiesChoose;
    }

    static void setMessagePropertiesChoose(MessagePropertiesChoose messagePropertiesChoose) {
        MessengerSenderSupport.messagePropertiesChoose = messagePropertiesChoose;
    }

    public static MessageChannelChoose getMessageChannelChoose() {
        return messageChannelChoose;
    }

    static void setMessageChannelChoose(MessageChannelChoose messageChannelChoose) {
        MessengerSenderSupport.messageChannelChoose = messageChannelChoose;
    }

    public static CurrentUserProvider getCurrentUserProvider() {
        return currentUserProvider;
    }

    static void setCurrentUserProvider(CurrentUserProvider currentUserProvider) {
        MessengerSenderSupport.currentUserProvider = currentUserProvider;
    }

    private static void validateMessengerProperties() {
        Assert.notBlank(messengerProperties.getServerUrl(), "消息服务器地址未配置");
    }
}
