package com.elitescloud.cloudt.messenger.message;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.Assert;

import java.util.Map;

/**
 * App消息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/31
 */
@Data
@ApiModel(description = "App消息")
public class AppMessageVO extends AbstractMessageSenderVO {
    private static final long serialVersionUID = -6707284955103230026L;

    /**
     * 点击后打开的目标页，为空则默认打开首页
     */
    @ApiModelProperty(value = "点击后跳转地址，默认首页", position = 11)
    private String targetUrl;

    /**
     * 业务类型
     */
    @ApiModelProperty(name = "业务类型", position = 12)
    private String businessType;

    /**
     * 业务参数
     */
    @ApiModelProperty(value = "业务参数", position = 13)
    private Map<String, String> businessParams;

    @Override
    protected void validate() {
        super.validate();

        Assert.hasText(businessType, "业务类型为空");
    }
}
