package com.elitescloud.cloudt.messenger.message;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.messenger.model.MessageAccountVO;
import com.elitescloud.cloudt.messenger.model.MessageAttachmentVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import java.util.List;
import java.util.Map;

/**
 * 邮件消息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/22
 */
@Data
@ApiModel(description = "邮件消息")
public class EmailMessageVO extends AbstractMessageSenderVO {
    private static final long serialVersionUID = -8006457807227607178L;

    /**
     * 回复人
     */
    @ApiModelProperty(value = "回复人", position = 11)
    @Valid
    private MessageAccountVO replyTo;

    /**
     * 抄送
     */
    @ApiModelProperty(value = "抄送人", position = 12)
    @Valid
    private List<MessageAccountVO> ccList;

    /**
     * 密送
     */
    @ApiModelProperty(value = "密送", position = 13)
    @Valid
    private List<MessageAccountVO> bccList;

    /**
     * 回执账号
     */
    @ApiModelProperty(value = "回执账号", position = 14)
    private String receiptAccount;

    /**
     * 附件
     */
    @ApiModelProperty(value = "附件", position = 21)
    @Valid
    private List<MessageAttachmentVO> attachments;

    /**
     * 是否是富文本邮件
     */
    @ApiModelProperty(value = "是否富文本邮件", position = 22)
    private Boolean richTextEmail;

    /**
     * 内联文件
     */
    @ApiModelProperty(value = "内联文件", position = 23)
    @Valid
    private Map<String, MessageAttachmentVO> inlineAttachments;

    @Override
    protected void validate() {
        super.validate();

        // 校验附件
        if (CollUtil.isNotEmpty(attachments)) {
            for (MessageAttachmentVO attachment : attachments) {
                super.validateAttachment(attachment);
            }
        }
        if (CollUtil.isNotEmpty(inlineAttachments)) {
            for (Map.Entry<String, MessageAttachmentVO> entry : inlineAttachments.entrySet()) {
                super.validateAttachment(entry.getValue());
            }
        }
    }
}
