package com.elitescloud.cloudt.messenger.message.builder;

import com.elitescloud.cloudt.messenger.message.AppMessageVO;
import com.elitescloud.cloudt.messenger.model.MessageAccountVO;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * App消息构建器.
 *
 * @author Kaiser（wang shao）
 * @date 2023/6/7
 */
public class AppMessageBuilder extends AbstractMessageBuilder<AppMessageBuilder, AppMessageVO> {

    /**
     * 点击后打开的目标页
     */
    private String targetUrl;

    /**
     * 业务类型
     */
    private String businessType;

    /**
     * 业务参数
     */
    private Map<String, String> businessParams;

    @Override
    public AppMessageVO build() {
        var messageVO = new AppMessageVO();
        messageVO.setTargetUrl(targetUrl);
        messageVO.setBusinessType(businessType);
        messageVO.setBusinessParams(businessParams);

        super.fillBaseMessage(messageVO);
        return messageVO;
    }

    @Override
    public AppMessageBuilder setRetryableOnFailure(Boolean retryableOnFailure) {
        return super.setRetryableOnFailure(retryableOnFailure);
    }

    @Override
    public AppMessageBuilder setSubject(String subject) {
        return super.setSubject(subject);
    }

    @Override
    public AppMessageBuilder setContent(String content) {
        return super.setContent(content);
    }

    @Override
    public AppMessageBuilder setSender(MessageAccountVO sender) {
        return super.setSender(sender);
    }

    @Override
    public AppMessageBuilder setReceiverList(List<MessageAccountVO> receiverList) {
        return super.setReceiverList(receiverList);
    }

    @Override
    public AppMessageBuilder addReceiver(MessageAccountVO receiver) {
        return super.addReceiver(receiver);
    }

    public AppMessageBuilder setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
        return self();
    }

    public AppMessageBuilder setBusinessType(String businessType) {
        this.businessType = businessType;
        return self();
    }

    public AppMessageBuilder setBusinessParams(Map<String, String> businessParams) {
        this.businessParams = businessParams;
        return self();
    }

    public AppMessageBuilder addBusinessParams(String key, String value) {
        if (this.businessParams == null) {
            this.businessParams = new HashMap<>();
        }
        this.businessParams.put(key, value);
        return self();
    }

    public AppMessageBuilder addBusinessParams(Map<String, String> businessParams) {
        if (businessParams == null) {
            return self();
        }
        if (this.businessParams == null) {
            this.businessParams = new HashMap<>();
        }
        this.businessParams.putAll(businessParams);
        return self();
    }

    @Override
    protected AppMessageBuilder self() {
        return super.self();
    }
}
