package com.elitescloud.cloudt.messenger.message.builder;

import com.elitescloud.cloudt.messenger.message.EmailMessageVO;
import com.elitescloud.cloudt.messenger.model.MessageAccountVO;
import com.elitescloud.cloudt.messenger.model.MessageAttachmentVO;
import org.springframework.util.Assert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 富文本邮件消息构建器.
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/19
 */
public class RichTextEmailMessageBuilder extends EmailMessageBuilder {

    /**
     * 内联文件
     */
    private Map<String, MessageAttachmentVO> inlineAttachments;

    @Override
    public EmailMessageVO build() {
        EmailMessageVO messageVO = new EmailMessageVO();
        messageVO.setReplyTo(this.replyTo);
        messageVO.setCcList(this.ccList);
        messageVO.setBccList(this.bccList);
        messageVO.setAttachments(this.attachments);
        messageVO.setRichTextEmail(true);
        messageVO.setInlineAttachments(this.inlineAttachments);
        // 基本信息
        super.fillBaseMessage(messageVO);

        // 设置发件人，默认是账号信息
        messageVO.setSender(super.detectSender());
        return messageVO;
    }

    public RichTextEmailMessageBuilder addInlineAttachment(String cid, MessageAttachmentVO attachmentVO) {
        // 校验参数
        Assert.hasText(cid, "内联标识为空");
        Assert.notNull(attachmentVO, "附件为空");
        attachmentVO.validate();

        if (inlineAttachments == null) {
            this.inlineAttachments = new HashMap<>(8);
        }
        this.inlineAttachments.put(cid, attachmentVO);

        return self();
    }

    public RichTextEmailMessageBuilder setInlineAttachments(Map<String, MessageAttachmentVO> inlineAttachments) {
        this.inlineAttachments = inlineAttachments;
        return self();
    }

    @Override
    public RichTextEmailMessageBuilder setRetryableOnFailure(Boolean retryableOnFailure) {
        super.setRetryableOnFailure(retryableOnFailure);
        return self();
    }

    @Override
    public RichTextEmailMessageBuilder setSubject(String subject) {
        super.setSubject(subject);
        return self();
    }

    @Override
    public RichTextEmailMessageBuilder setContent(String content) {
        super.setContent(content);
        return self();
    }

    @Override
    public RichTextEmailMessageBuilder setSender(MessageAccountVO sender) {
        super.setSender(sender);
        return self();
    }

    @Override
    public RichTextEmailMessageBuilder setReceiverList(List<MessageAccountVO> receiverList) {
        super.setReceiverList(receiverList);
        return self();
    }

    @Override
    public RichTextEmailMessageBuilder addReceiver(MessageAccountVO receiver) {
        super.addReceiver(receiver);
        return self();
    }

    @Override
    public RichTextEmailMessageBuilder setReplyTo(MessageAccountVO replyTo) {
        super.setReplyTo(replyTo);
        return self();
    }

    @Override
    public RichTextEmailMessageBuilder setCcList(List<MessageAccountVO> ccList) {
        super.setCcList(ccList);
        return self();
    }

    @Override
    public RichTextEmailMessageBuilder addCc(MessageAccountVO cc) {
        if (cc == null) {
            return self();
        }
        if (this.ccList == null) {
            this.ccList = new ArrayList<>();
        }
        this.ccList.add(cc);
        return self();
    }

    @Override
    public RichTextEmailMessageBuilder addCc(List<MessageAccountVO> cc) {
        if (cc == null) {
            return self();
        }
        if (this.ccList == null) {
            this.ccList = new ArrayList<>();
        }
        this.ccList.addAll(cc);
        return self();
    }

    @Override
    public RichTextEmailMessageBuilder setBccList(List<MessageAccountVO> bccList) {
        super.setBccList(bccList);
        return self();
    }

    @Override
    public RichTextEmailMessageBuilder addBcc(MessageAccountVO bcc) {
        if (bcc == null) {
            return self();
        }
        if (this.bccList == null) {
            this.bccList = new ArrayList<>();
        }
        this.bccList.add(bcc);
        return self();
    }

    @Override
    public RichTextEmailMessageBuilder addBcc(List<MessageAccountVO> bcc) {
        if (bcc == null) {
            return self();
        }
        if (this.bccList == null) {
            this.bccList = new ArrayList<>();
        }
        this.bccList.addAll(bcc);
        return self();
    }

    public RichTextEmailMessageBuilder setReceiptAccount(String receiptAccount) {
        this.receiptAccount = receiptAccount;
        return self();
    }

    @Override
    public RichTextEmailMessageBuilder setAttachments(List<MessageAttachmentVO> attachments) {
        super.setAttachments(attachments);
        return self();
    }

    public RichTextEmailMessageBuilder addAttachments(MessageAttachmentVO attachmentVO) {
        Assert.notNull(attachmentVO, "附件为空");
        attachmentVO.validate();

        if (attachments == null) {
            attachments = new ArrayList<>(8);
        }
        attachments.add(attachmentVO);

        return self();
    }

    @Override
    protected RichTextEmailMessageBuilder self() {
        return this;
    }
}
