package com.elitescloud.cloudt.messenger.message.builder;

import com.elitescloud.cloudt.messenger.message.SmsMessageVO;
import com.elitescloud.cloudt.messenger.model.MessageAccountVO;

import java.util.List;

/**
 * 短信消息构建器.
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/19
 */
public class SmsMessageBuilder extends AbstractMessageBuilder<SmsMessageBuilder, SmsMessageVO> {

    /**
     * 短信签名
     */
    protected String signName;

    @Override
    public SmsMessageVO build() {
        SmsMessageVO messageVO = new SmsMessageVO();
        messageVO.setSignName(this.signName);
        messageVO.setTemplateMsg(false);
        messageVO.setTemplateCode(null);
        messageVO.setTemplateParam(null);

        super.fillBaseMessage(messageVO);
        return messageVO;
    }

    @Override
    public SmsMessageBuilder setRetryableOnFailure(Boolean retryableOnFailure) {
        return super.setRetryableOnFailure(retryableOnFailure);
    }

    @Override
    public SmsMessageBuilder setSubject(String subject) {
        return super.setSubject(subject);
    }

    @Override
    public SmsMessageBuilder setContent(String content) {
        return super.setContent(content);
    }

    @Override
    public SmsMessageBuilder setSender(MessageAccountVO sender) {
        return super.setSender(sender);
    }

    @Override
    public SmsMessageBuilder setReceiverList(List<MessageAccountVO> receiverList) {
        return super.setReceiverList(receiverList);
    }

    public SmsMessageBuilder addReceiver(MessageAccountVO receiver) {
        return super.addReceiver(receiver);
    }

    public SmsMessageBuilder setSignName(String signName) {
        this.signName = signName;
        return self();
    }

    @Override
    protected SmsMessageBuilder self() {
        return this;
    }
}
