/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.messenger.config.support;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.util.RestTemplateFactory;
import com.elitescloud.boot.util.RestTemplateHelper;
import com.elitescloud.cloudt.common.base.RpcResult;
import com.elitescloud.cloudt.messenger.common.MsgReceiveStatusEnum;
import com.elitescloud.cloudt.messenger.config.CloudtMessengerProperties;
import com.elitescloud.cloudt.messenger.config.MessengerSenderSupport;
import com.elitescloud.cloudt.messenger.message.AppMessageVO;
import com.elitescloud.cloudt.messenger.message.EmailMessageVO;
import com.elitescloud.cloudt.messenger.message.SiteMessageVO;
import com.elitescloud.cloudt.messenger.message.SmsMessageVO;
import com.elitescloud.cloudt.messenger.model.AbstractMessageVO;
import com.elitescloud.cloudt.messenger.model.dto.MsgResultDTO;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class CloudtMessengerSender {
    private static final Logger LOG = LoggerFactory.getLogger(CloudtMessengerSender.class);
    private static CloudtMessengerSender messangerSender;
    private final RestTemplateHelper restTemplateHelper;

    private CloudtMessengerSender(CloudtMessengerProperties messengerProperties) {
        RestTemplate restTemplate = this.buildRestTemplate(messengerProperties);
        this.restTemplateHelper = RestTemplateHelper.instance((RestTemplate)restTemplate);
    }

    public static CloudtMessengerSender instance() {
        if (messangerSender == null) {
            return CloudtMessengerSender.buildInstance();
        }
        return messangerSender;
    }

    public <T extends AbstractMessageVO> String send(T messenger) {
        String uri = this.detectSendUri(messenger);
        RpcResult rpcResult = null;
        try {
            rpcResult = (RpcResult)this.restTemplateHelper.exchange(uri, HttpMethod.POST, new HttpEntity(messenger), (ParameterizedTypeReference)new ParameterizedTypeReference<RpcResult<String>>(){}, new Object[0]);
        }
        catch (Exception e) {
            LOG.error("\u53d1\u9001\u6d88\u606f\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
        LOG.info("\u53d1\u9001\u6d88\u606f{}\u7ed3\u679c\uff1a{}, {}", new Object[]{uri, rpcResult.getMsg(), rpcResult.getData()});
        if (rpcResult.isSuccess()) {
            return (String)rpcResult.getData();
        }
        return null;
    }

    public String getMsgStatus(@NotBlank String messageId) {
        Assert.notBlank((CharSequence)messageId, (String)"\u6d88\u606fID\u4e3a\u7a7a", (Object[])new Object[0]);
        String uri = "/api/msg/status?messageId={messageId}";
        RpcResult rpcResult = null;
        try {
            rpcResult = (RpcResult)this.restTemplateHelper.exchange(uri, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<RpcResult<String>>(){}, new Object[]{messageId});
        }
        catch (Exception e) {
            LOG.error("\u67e5\u8be2\u6d88\u606f\u72b6\u6001\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
        LOG.info("\u67e5\u8be2\u6d88\u606f{}\u72b6\u6001\uff1a{}, {}", new Object[]{uri, rpcResult.getMsg(), rpcResult.getData()});
        return (String)rpcResult.getData();
    }

    public Map<String, String> queryMsgStatus(@NotEmpty Set<String> messageIds) {
        Assert.notEmpty(messageIds, (String)"\u6d88\u606fID\u4e3a\u7a7a", (Object[])new Object[0]);
        String uri = "/api/msg/statusList";
        RpcResult rpcResult = null;
        try {
            rpcResult = (RpcResult)this.restTemplateHelper.exchange(uri, HttpMethod.POST, new HttpEntity(messageIds), (ParameterizedTypeReference)new ParameterizedTypeReference<RpcResult<Map<String, String>>>(){}, new Object[0]);
        }
        catch (Exception e) {
            LOG.error("\u67e5\u8be2\u6d88\u606f\u72b6\u6001\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
        LOG.info("\u67e5\u8be2\u6d88\u606f{}\u72b6\u6001\uff1a{}, {}", new Object[]{uri, rpcResult.getMsg(), rpcResult.getData()});
        return (Map)ObjectUtil.defaultIfNull((Object)((Map)rpcResult.getData()), Collections.emptyMap());
    }

    public Map<String, String> queryMsgReceiveStatus(@NotBlank String messageId) {
        Assert.notBlank((CharSequence)messageId, (String)"\u6d88\u606fID\u4e3a\u7a7a", (Object[])new Object[0]);
        String uri = "/api/msg/receive/status?messageId={messageId}";
        RpcResult rpcResult = null;
        try {
            rpcResult = (RpcResult)this.restTemplateHelper.exchange(uri, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<RpcResult<Map<String, String>>>(){}, new Object[]{messageId});
        }
        catch (Exception e) {
            LOG.error("\u67e5\u8be2\u6d88\u606f\u63a5\u6536\u72b6\u6001\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
        LOG.info("\u67e5\u8be2\u6d88\u606f{}\u63a5\u6536\u72b6\u6001\uff1a{}, {}", new Object[]{uri, rpcResult.getMsg(), rpcResult.getData()});
        return (Map)ObjectUtil.defaultIfNull((Object)((Map)rpcResult.getData()), Collections.emptyMap());
    }

    public MsgResultDTO querySendResult(@NotBlank String messageId) {
        Assert.notBlank((CharSequence)messageId, (String)"\u6d88\u606fID\u4e3a\u7a7a", (Object[])new Object[0]);
        String uri = "/api/msg/result?messageId={messageId}";
        RpcResult rpcResult = null;
        try {
            rpcResult = (RpcResult)this.restTemplateHelper.exchange(uri, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<RpcResult<MsgResultDTO>>(){}, new Object[]{messageId});
        }
        catch (Exception e) {
            LOG.error("\u67e5\u8be2\u6d88\u606f\u53d1\u9001\u7ed3\u679c\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
        LOG.info("\u67e5\u8be2\u6d88\u606f{}\u53d1\u9001\u7ed3\u679c\uff1a{}, {}", new Object[]{uri, rpcResult.getMsg(), rpcResult.getData()});
        return (MsgResultDTO)rpcResult.getData();
    }

    public List<MsgResultDTO> querySendResult(@NotEmpty Collection<String> messageIds) {
        Assert.notEmpty(messageIds, (String)"\u6d88\u606fID\u4e3a\u7a7a", (Object[])new Object[0]);
        String uri = "/api/msg/resultList";
        RpcResult rpcResult = null;
        try {
            rpcResult = (RpcResult)this.restTemplateHelper.exchange(uri, HttpMethod.POST, new HttpEntity(messageIds, null), (ParameterizedTypeReference)new ParameterizedTypeReference<RpcResult<List<MsgResultDTO>>>(){}, new Object[0]);
        }
        catch (Exception e) {
            LOG.error("\u67e5\u8be2\u6d88\u606f\u53d1\u9001\u7ed3\u679c\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
        LOG.info("\u67e5\u8be2\u6d88\u606f{}\u53d1\u9001\u7ed3\u679c\uff1a{}, {}", new Object[]{uri, rpcResult.getMsg(), rpcResult.getData()});
        return (List)rpcResult.getData();
    }

    public String retryMsg(@NotBlank String messageId, Boolean sync) {
        Assert.notBlank((CharSequence)messageId, (String)"\u6d88\u606fID\u4e3a\u7a7a", (Object[])new Object[0]);
        if (sync == null) {
            sync = false;
        }
        String uri = "/api/sender/retry?messageId={messageId}&sync={sync}";
        RpcResult rpcResult = null;
        try {
            rpcResult = (RpcResult)this.restTemplateHelper.exchange(uri, HttpMethod.PUT, null, (ParameterizedTypeReference)new ParameterizedTypeReference<RpcResult<String>>(){}, new Object[]{messageId, sync});
        }
        catch (Exception e) {
            LOG.error("\u91cd\u8bd5\u53d1\u9001\u6d88\u606f\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
        LOG.info("\u91cd\u8bd5\u6d88\u606f{}\u7ed3\u679c\uff1a{}, {}", new Object[]{uri, rpcResult.getMsg(), rpcResult.getData()});
        return (String)rpcResult.getData();
    }

    public Boolean updateMsgReceiveStatus(@NotBlank String messageId, @NotBlank String receiver, @NotNull MsgReceiveStatusEnum receiveStatus) {
        Assert.notBlank((CharSequence)messageId, (String)"\u6d88\u606fID\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)receiver, (String)"\u63a5\u6536\u4eba\u8d26\u53f7\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)receiveStatus, (String)"\u63a5\u6536\u72b6\u6001\u4e3a\u7a7a", (Object[])new Object[0]);
        String uri = "/api/msg/receive/updateStatus?messageId={messageId}&receiver={receiver}&receiveStatus={receiveStatus}";
        RpcResult rpcResult = null;
        try {
            rpcResult = (RpcResult)this.restTemplateHelper.exchange(uri, HttpMethod.PATCH, null, (ParameterizedTypeReference)new ParameterizedTypeReference<RpcResult<Boolean>>(){}, new Object[]{messageId, receiver, receiveStatus.name()});
        }
        catch (Exception e) {
            LOG.error("\u66f4\u65b0\u6d88\u606f\u63a5\u6536\u72b6\u6001\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
        LOG.info("\u66f4\u65b0\u6d88\u606f{}\u63a5\u6536\u72b6\u6001\uff1a{}, {}", new Object[]{uri, rpcResult.getMsg(), rpcResult.getData()});
        return (Boolean)ObjectUtil.defaultIfNull((Object)((Boolean)rpcResult.getData()), (Object)false);
    }

    private RestTemplate buildRestTemplate(CloudtMessengerProperties messengerProperties) {
        Function<RestTemplateBuilder, RestTemplateBuilder> restTemplateBuilderFunction = builder -> builder.rootUri(messengerProperties.getServerUrl()).additionalInterceptors(new ClientHttpRequestInterceptor[]{new AuthorizationInterceptor(messengerProperties)});
        return RestTemplateFactory.dynamicInstance(restTemplateBuilderFunction, (String[])new String[]{"coord-messenger"});
    }

    private <T extends AbstractMessageVO> String detectSendUri(T messenger) {
        if (messenger instanceof SmsMessageVO) {
            return "/api/sender/sms";
        }
        if (messenger instanceof EmailMessageVO) {
            return "/api/sender/email";
        }
        if (messenger instanceof SiteMessageVO) {
            return "/api/sender/site";
        }
        if (messenger instanceof AppMessageVO) {
            return "/api/sender/app";
        }
        throw new IllegalStateException("\u53d1\u9001\u5931\u8d25\uff0c\u6682\u4e0d\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CloudtMessengerSender buildInstance() {
        Assert.state((MessengerSenderSupport.getMessengerProperties() != null ? 1 : 0) != 0, (String)"\u6d88\u606f\u53d1\u9001\u521d\u59cb\u5316\u5931\u8d25", (Object[])new Object[0]);
        Class<CloudtMessengerSender> clazz = CloudtMessengerSender.class;
        synchronized (CloudtMessengerSender.class) {
            if (messangerSender != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return messangerSender;
            }
            messangerSender = new CloudtMessengerSender(MessengerSenderSupport.getMessengerProperties());
            // ** MonitorExit[var0] (shouldn't be in output)
            return messangerSender;
        }
    }

    static class AuthorizationInterceptor
    implements ClientHttpRequestInterceptor {
        private final CloudtMessengerProperties messengerProperties;

        public AuthorizationInterceptor(CloudtMessengerProperties messengerProperties) {
            this.messengerProperties = messengerProperties;
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            HttpServletRequest originalRequest;
            String token;
            RequestAttributes requestAttributes;
            if (Boolean.TRUE.equals(this.messengerProperties.getAuthorization()) && (requestAttributes = RequestContextHolder.getRequestAttributes()) != null && StringUtils.hasText((String)(token = (originalRequest = ((ServletRequestAttributes)requestAttributes).getRequest()).getHeader("Authorization")))) {
                request.getHeaders().add("Authorization", token);
            }
            return execution.execute(request, body);
        }
    }
}

