/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.messenger.message.builder;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.messenger.message.AbstractMessageSenderVO;
import com.elitescloud.cloudt.messenger.model.MessageAccountVO;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;

public abstract class AbstractMessageBuilder<T extends AbstractMessageBuilder<T, M>, M extends AbstractMessageSenderVO> {
    @NotBlank
    private String subject;
    @NotBlank
    private String content;
    private MessageAccountVO sender;
    @NotEmpty
    private List<MessageAccountVO> receiverList;
    private Boolean retryableOnFailure;

    public abstract M build();

    protected final void fillBaseMessage(M messageVO) {
        messageVO.setRetryableOnFailure(this.retryableOnFailure);
        messageVO.setSubject((String)Assert.notBlank((CharSequence)this.subject, (String)"\u6d88\u606f\u4e3b\u9898\u4e3a\u7a7a", (Object[])new Object[0]));
        messageVO.setContent((String)Assert.notBlank((CharSequence)this.content, (String)"\u53d1\u9001\u5185\u5bb9\u4e3a\u7a7a", (Object[])new Object[0]));
        messageVO.setSender(this.sender);
        messageVO.setReceiverList((List)Assert.notEmpty(this.receiverList, (String)"\u63a5\u6536\u4eba\u4e3a\u7a7a", (Object[])new Object[0]));
    }

    protected T setRetryableOnFailure(Boolean retryableOnFailure) {
        this.retryableOnFailure = retryableOnFailure;
        return this.self();
    }

    protected T setSubject(String subject) {
        this.subject = subject;
        return this.self();
    }

    protected T setContent(String content) {
        this.content = content;
        return this.self();
    }

    protected T setSender(MessageAccountVO sender) {
        this.sender = sender;
        return this.self();
    }

    protected T setReceiverList(List<MessageAccountVO> receiverList) {
        this.receiverList = receiverList;
        return this.self();
    }

    protected T addReceiver(MessageAccountVO receiver) {
        if (receiver == null) {
            return this.self();
        }
        if (this.receiverList == null) {
            this.receiverList = new ArrayList<MessageAccountVO>();
        }
        this.receiverList.add(receiver);
        return this.self();
    }

    protected T self() {
        return (T)this;
    }
}

