/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.messenger.message.builder;

import com.elitescloud.cloudt.messenger.message.AppMessageVO;
import com.elitescloud.cloudt.messenger.message.builder.AbstractMessageBuilder;
import com.elitescloud.cloudt.messenger.model.MessageAccountVO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppMessageBuilder
extends AbstractMessageBuilder<AppMessageBuilder, AppMessageVO> {
    private String targetUrl;
    private String businessType;
    private Map<String, String> businessParams;

    @Override
    public AppMessageVO build() {
        AppMessageVO messageVO = new AppMessageVO();
        messageVO.setTargetUrl(this.targetUrl);
        messageVO.setBusinessType(this.businessType);
        messageVO.setBusinessParams(this.businessParams);
        super.fillBaseMessage(messageVO);
        return messageVO;
    }

    @Override
    public AppMessageBuilder setRetryableOnFailure(Boolean retryableOnFailure) {
        return (AppMessageBuilder)super.setRetryableOnFailure(retryableOnFailure);
    }

    @Override
    public AppMessageBuilder setSubject(String subject) {
        return (AppMessageBuilder)super.setSubject(subject);
    }

    @Override
    public AppMessageBuilder setContent(String content) {
        return (AppMessageBuilder)super.setContent(content);
    }

    @Override
    public AppMessageBuilder setSender(MessageAccountVO sender) {
        return (AppMessageBuilder)super.setSender(sender);
    }

    @Override
    public AppMessageBuilder setReceiverList(List<MessageAccountVO> receiverList) {
        return (AppMessageBuilder)super.setReceiverList(receiverList);
    }

    @Override
    public AppMessageBuilder addReceiver(MessageAccountVO receiver) {
        return (AppMessageBuilder)super.addReceiver(receiver);
    }

    public AppMessageBuilder setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
        return this.self();
    }

    public AppMessageBuilder setBusinessType(String businessType) {
        this.businessType = businessType;
        return this.self();
    }

    public AppMessageBuilder setBusinessParams(Map<String, String> businessParams) {
        this.businessParams = businessParams;
        return this.self();
    }

    public AppMessageBuilder addBusinessParams(String key, String value) {
        if (this.businessParams == null) {
            this.businessParams = new HashMap<String, String>();
        }
        this.businessParams.put(key, value);
        return this.self();
    }

    public AppMessageBuilder addBusinessParams(Map<String, String> businessParams) {
        if (businessParams == null) {
            return this.self();
        }
        if (this.businessParams == null) {
            this.businessParams = new HashMap<String, String>();
        }
        this.businessParams.putAll(businessParams);
        return this.self();
    }

    @Override
    protected AppMessageBuilder self() {
        return (AppMessageBuilder)super.self();
    }
}

