/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.messenger.message.builder;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.messenger.config.MessengerSenderSupport;
import com.elitescloud.cloudt.messenger.message.EmailMessageVO;
import com.elitescloud.cloudt.messenger.message.builder.AbstractMessageBuilder;
import com.elitescloud.cloudt.messenger.model.MessageAccountVO;
import com.elitescloud.cloudt.messenger.model.MessageAttachmentVO;
import com.elitescloud.cloudt.messenger.model.config.EmailMessagePropertiesVO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.util.StringUtils;

public class EmailMessageBuilder
extends AbstractMessageBuilder<EmailMessageBuilder, EmailMessageVO> {
    protected MessageAccountVO replyTo;
    protected List<MessageAccountVO> ccList;
    protected List<MessageAccountVO> bccList;
    protected String receiptAccount;
    protected List<MessageAttachmentVO> attachments;

    @Override
    public EmailMessageVO build() {
        EmailMessageVO messageVO = new EmailMessageVO();
        messageVO.setReplyTo(this.replyTo);
        messageVO.setCcList(this.ccList);
        messageVO.setBccList(this.bccList);
        messageVO.setReceiptAccount(this.receiptAccount);
        messageVO.setAttachments(this.attachments);
        messageVO.setRichTextEmail(false);
        messageVO.setInlineAttachments(Collections.emptyMap());
        super.fillBaseMessage(messageVO);
        messageVO.setSender(this.detectSender());
        return messageVO;
    }

    protected MessageAccountVO detectSender() {
        EmailMessagePropertiesVO emailProperties = MessengerSenderSupport.getMessengerProperties().getSender().getEmail();
        if (StringUtils.hasText((String)emailProperties.getUsername())) {
            return new MessageAccountVO(emailProperties.getUsername(), CharSequenceUtil.blankToDefault((CharSequence)emailProperties.getShowName(), (String)emailProperties.getUsername()));
        }
        return null;
    }

    @Override
    public EmailMessageBuilder setRetryableOnFailure(Boolean retryableOnFailure) {
        return (EmailMessageBuilder)super.setRetryableOnFailure(retryableOnFailure);
    }

    @Override
    public EmailMessageBuilder setSubject(String subject) {
        return (EmailMessageBuilder)super.setSubject(subject);
    }

    @Override
    public EmailMessageBuilder setContent(String content) {
        return (EmailMessageBuilder)super.setContent(content);
    }

    @Override
    public EmailMessageBuilder setSender(MessageAccountVO sender) {
        return (EmailMessageBuilder)super.setSender(sender);
    }

    @Override
    public EmailMessageBuilder setReceiverList(List<MessageAccountVO> receiverList) {
        return (EmailMessageBuilder)super.setReceiverList(receiverList);
    }

    @Override
    public EmailMessageBuilder addReceiver(MessageAccountVO receiver) {
        return (EmailMessageBuilder)super.addReceiver(receiver);
    }

    public EmailMessageBuilder setReplyTo(MessageAccountVO replyTo) {
        this.replyTo = replyTo;
        return this.self();
    }

    public EmailMessageBuilder setCcList(List<MessageAccountVO> ccList) {
        this.ccList = ccList;
        return this.self();
    }

    public EmailMessageBuilder addCc(MessageAccountVO cc) {
        if (cc == null) {
            return this.self();
        }
        if (this.ccList == null) {
            this.ccList = new ArrayList<MessageAccountVO>();
        }
        this.ccList.add(cc);
        return this.self();
    }

    public EmailMessageBuilder addCc(List<MessageAccountVO> cc) {
        if (cc == null) {
            return this.self();
        }
        if (this.ccList == null) {
            this.ccList = new ArrayList<MessageAccountVO>();
        }
        this.ccList.addAll(cc);
        return this.self();
    }

    public EmailMessageBuilder setBccList(List<MessageAccountVO> bccList) {
        this.bccList = bccList;
        return this.self();
    }

    public EmailMessageBuilder addBcc(MessageAccountVO bcc) {
        if (bcc == null) {
            return this.self();
        }
        if (this.bccList == null) {
            this.bccList = new ArrayList<MessageAccountVO>();
        }
        this.bccList.add(bcc);
        return this.self();
    }

    public EmailMessageBuilder addBcc(List<MessageAccountVO> bcc) {
        if (bcc == null) {
            return this.self();
        }
        if (this.bccList == null) {
            this.bccList = new ArrayList<MessageAccountVO>();
        }
        this.bccList.addAll(bcc);
        return this.self();
    }

    public EmailMessageBuilder setReceiptAccount(String receiptAccount) {
        this.receiptAccount = receiptAccount;
        return this.self();
    }

    public EmailMessageBuilder setAttachments(List<MessageAttachmentVO> attachments) {
        this.attachments = attachments;
        return this.self();
    }

    public EmailMessageBuilder addAttachments(MessageAttachmentVO attachmentVO) {
        if (attachmentVO == null) {
            return this.self();
        }
        attachmentVO.validate();
        if (this.attachments == null) {
            this.attachments = new ArrayList<MessageAttachmentVO>(8);
        }
        this.attachments.add(attachmentVO);
        return this.self();
    }

    @Override
    protected EmailMessageBuilder self() {
        return this;
    }
}

