/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.messenger.message.builder;

import com.elitescloud.cloudt.messenger.message.EmailMessageVO;
import com.elitescloud.cloudt.messenger.message.builder.EmailMessageBuilder;
import com.elitescloud.cloudt.messenger.model.MessageAccountVO;
import com.elitescloud.cloudt.messenger.model.MessageAttachmentVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;

public class RichTextEmailMessageBuilder
extends EmailMessageBuilder {
    private Map<String, MessageAttachmentVO> inlineAttachments;

    @Override
    public EmailMessageVO build() {
        EmailMessageVO messageVO = new EmailMessageVO();
        messageVO.setReplyTo(this.replyTo);
        messageVO.setCcList(this.ccList);
        messageVO.setBccList(this.bccList);
        messageVO.setAttachments(this.attachments);
        messageVO.setRichTextEmail(true);
        messageVO.setInlineAttachments(this.inlineAttachments);
        super.fillBaseMessage(messageVO);
        messageVO.setSender(super.detectSender());
        return messageVO;
    }

    public RichTextEmailMessageBuilder addInlineAttachment(String cid, MessageAttachmentVO attachmentVO) {
        Assert.hasText((String)cid, (String)"\u5185\u8054\u6807\u8bc6\u4e3a\u7a7a");
        Assert.notNull((Object)attachmentVO, (String)"\u9644\u4ef6\u4e3a\u7a7a");
        attachmentVO.validate();
        if (this.inlineAttachments == null) {
            this.inlineAttachments = new HashMap<String, MessageAttachmentVO>(8);
        }
        this.inlineAttachments.put(cid, attachmentVO);
        return this.self();
    }

    public RichTextEmailMessageBuilder setInlineAttachments(Map<String, MessageAttachmentVO> inlineAttachments) {
        this.inlineAttachments = inlineAttachments;
        return this.self();
    }

    @Override
    public RichTextEmailMessageBuilder setRetryableOnFailure(Boolean retryableOnFailure) {
        super.setRetryableOnFailure(retryableOnFailure);
        return this.self();
    }

    @Override
    public RichTextEmailMessageBuilder setSubject(String subject) {
        super.setSubject(subject);
        return this.self();
    }

    @Override
    public RichTextEmailMessageBuilder setContent(String content) {
        super.setContent(content);
        return this.self();
    }

    @Override
    public RichTextEmailMessageBuilder setSender(MessageAccountVO sender) {
        super.setSender(sender);
        return this.self();
    }

    @Override
    public RichTextEmailMessageBuilder setReceiverList(List<MessageAccountVO> receiverList) {
        super.setReceiverList((List)receiverList);
        return this.self();
    }

    @Override
    public RichTextEmailMessageBuilder addReceiver(MessageAccountVO receiver) {
        super.addReceiver(receiver);
        return this.self();
    }

    @Override
    public RichTextEmailMessageBuilder setReplyTo(MessageAccountVO replyTo) {
        super.setReplyTo(replyTo);
        return this.self();
    }

    @Override
    public RichTextEmailMessageBuilder setCcList(List<MessageAccountVO> ccList) {
        super.setCcList(ccList);
        return this.self();
    }

    @Override
    public RichTextEmailMessageBuilder addCc(MessageAccountVO cc) {
        if (cc == null) {
            return this.self();
        }
        if (this.ccList == null) {
            this.ccList = new ArrayList();
        }
        this.ccList.add(cc);
        return this.self();
    }

    @Override
    public RichTextEmailMessageBuilder addCc(List<MessageAccountVO> cc) {
        if (cc == null) {
            return this.self();
        }
        if (this.ccList == null) {
            this.ccList = new ArrayList();
        }
        this.ccList.addAll(cc);
        return this.self();
    }

    @Override
    public RichTextEmailMessageBuilder setBccList(List<MessageAccountVO> bccList) {
        super.setBccList(bccList);
        return this.self();
    }

    @Override
    public RichTextEmailMessageBuilder addBcc(MessageAccountVO bcc) {
        if (bcc == null) {
            return this.self();
        }
        if (this.bccList == null) {
            this.bccList = new ArrayList();
        }
        this.bccList.add(bcc);
        return this.self();
    }

    @Override
    public RichTextEmailMessageBuilder addBcc(List<MessageAccountVO> bcc) {
        if (bcc == null) {
            return this.self();
        }
        if (this.bccList == null) {
            this.bccList = new ArrayList();
        }
        this.bccList.addAll(bcc);
        return this.self();
    }

    @Override
    public RichTextEmailMessageBuilder setReceiptAccount(String receiptAccount) {
        this.receiptAccount = receiptAccount;
        return this.self();
    }

    @Override
    public RichTextEmailMessageBuilder setAttachments(List<MessageAttachmentVO> attachments) {
        super.setAttachments(attachments);
        return this.self();
    }

    @Override
    public RichTextEmailMessageBuilder addAttachments(MessageAttachmentVO attachmentVO) {
        Assert.notNull((Object)attachmentVO, (String)"\u9644\u4ef6\u4e3a\u7a7a");
        attachmentVO.validate();
        if (this.attachments == null) {
            this.attachments = new ArrayList(8);
        }
        this.attachments.add(attachmentVO);
        return this.self();
    }

    @Override
    protected RichTextEmailMessageBuilder self() {
        return this;
    }
}

