package com.elitescloud.boot.mq.compensate.config;

import com.elitescloud.boot.mq.compensate.controller.SysRocketMqConsumeFailLogController;
import com.elitescloud.boot.mq.compensate.controller.SysRocketMqConsumeLogController;
import com.elitescloud.boot.mq.compensate.output.CloudTMqSink;
import com.elitescloud.boot.mq.compensate.output.CloudTMqSource;
import com.elitescloud.boot.mq.compensate.service.SysRocketMqConsumeFailLogService;
import com.elitescloud.boot.mq.compensate.service.SysRocketMqConsumeLogService;
import com.elitescloud.boot.mq.compensate.service.impl.SysRocketMqConsumeFailLogServiceImpl;
import com.elitescloud.boot.mq.compensate.service.impl.SysRocketMqConsumeLogServiceImpl;
import com.elitescloud.boot.mq.compensate.utils.MQConsumeUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.config.BindingServiceConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author roman
 * @since 2022/4/6 9:27 AM
 */
@ConditionalOnClass({BindingServiceConfiguration.class, CompensateSwaggerConfig.class})
@ConditionalOnProperty(prefix = "spring.cloud.stream.bindings.cloudt-input", value = "destination")
@EnableBinding({CloudTMqSource.class, CloudTMqSink.class})
@Import({CompensateSwaggerConfig.class})
public class CloudStreamConfig {

    @Bean
    public SysRocketMqConsumeFailLogController sysRocketMqConsumeFailLogController() {
        return new SysRocketMqConsumeFailLogController();
    }

    @Bean
    public SysRocketMqConsumeLogController sysRocketMqConsumeLogController() {
        return new SysRocketMqConsumeLogController();
    }

    @Bean
    public SysRocketMqConsumeFailLogService sysRocketMqConsumeFailLogService() {
        return new SysRocketMqConsumeFailLogServiceImpl();
    }

    @Bean
    public SysRocketMqConsumeLogService sysRocketMqConsumeLogService() {
        return new SysRocketMqConsumeLogServiceImpl();
    }

    @Bean
    public MQConsumeUtils mqConsumeUtils() {
        return new MQConsumeUtils();
    }
}
